/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Objects;

public final class TypeUtils {
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static Object readNativeValue(Type type, Block block, int position) {
        Class<?> javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static Block writeNativeValue(Type type, @Nullable Object value) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        TypeUtils.writeNativeValue(type, blockBuilder, value);
        return blockBuilder.build();
    }

    public static void writeNativeValue(Type type, BlockBuilder blockBuilder, @Nullable Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, (Boolean)value);
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, (Double)value);
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, (Long)value);
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])((byte[])value)) : (value instanceof String ? Slices.utf8Slice((String)((String)value)) : (Slice)value);
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }

    public static boolean isFloatingPointNaN(Type type, Object value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        if (type == DoubleType.DOUBLE) {
            return Double.isNaN((Double)value);
        }
        if (type == RealType.REAL) {
            return Float.isNaN(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        return false;
    }

    static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }
}

