/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.UUID;

public class UuidType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(UuidType.class, MethodHandles.lookup(), Slice.class);
    private static final VarHandle LONG_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    public static final UuidType UUID = new UuidType();

    private UuidType() {
        super(new TypeSignature("uuid", new TypeSignatureParameter[0]), Slice.class);
    }

    @Override
    public int getFixedSize() {
        return 16;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new Int128ArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new Int128ArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long high = Long.reverseBytes(block.getLong(position, 0));
        long low = Long.reverseBytes(block.getLong(position, 8));
        return new UUID(high, low).toString();
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(block.getLong(position, 0), block.getLong(position, 8));
        }
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (length != 16) {
            throw new IllegalStateException("Expected entry size to be exactly 16 but was " + length);
        }
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(value.getLong(offset), value.getLong(offset + 8));
    }

    @Override
    public final Slice getSlice(Block block, int position) {
        Slice value = Slices.allocate((int)16);
        value.setLong(0, block.getLong(position, 0));
        value.setLong(8, block.getLong(position, 8));
        return value;
    }

    @Override
    public int getFlatFixedSize() {
        return 16;
    }

    public static Slice javaUuidToTrinoUuid(UUID uuid) {
        Slice value = Slices.allocate((int)16);
        value.setLong(0, Long.reverseBytes(uuid.getMostSignificantBits()));
        value.setLong(8, Long.reverseBytes(uuid.getLeastSignificantBits()));
        return value;
    }

    public static UUID trinoUuidToJavaUuid(Slice uuid) {
        if (uuid.length() != 16) {
            throw new IllegalStateException(String.format("Expected value to be exactly %d bytes but was %d", 16, uuid.length()));
        }
        return new UUID(Long.reverseBytes(uuid.getLong(0)), Long.reverseBytes(uuid.getLong(8)));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static Slice readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return Slices.wrappedBuffer((byte[])fixedSizeSlice, (int)fixedSizeOffset, (int)16);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(Slice sourceSlice, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        sourceSlice.getBytes(0, fixedSizeSlice, fixedSizeOffset, 16);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void readFlatToBlock(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice, BlockBuilder blockBuilder) {
        ((Int128ArrayBlockBuilder)blockBuilder).writeInt128(LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset), LONG_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(Slice left, Slice right) {
        return UuidType.equal(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return UuidType.equal(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static boolean equal(long leftLow, long leftHigh, long rightLow, long rightHigh) {
        return leftLow == rightLow && leftHigh == rightHigh;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(Slice value) {
        return UuidType.xxHash64(value.getLong(0), value.getLong(8));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    private static long xxHash64Operator(@BlockPosition Block block, @BlockIndex int position) {
        return UuidType.xxHash64(block.getLong(position, 0), block.getLong(position, 8));
    }

    private static long xxHash64(long low, long high) {
        return XxHash64.hash((long)low) ^ XxHash64.hash((long)high);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(Slice left, Slice right) {
        return UuidType.compareLittleEndian(left.getLong(0), left.getLong(8), right.getLong(0), right.getLong(8));
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonOperator(@BlockPosition Block leftBlock, @BlockIndex int leftPosition, @BlockPosition Block rightBlock, @BlockIndex int rightPosition) {
        return UuidType.compareLittleEndian(leftBlock.getLong(leftPosition, 0), leftBlock.getLong(leftPosition, 8), rightBlock.getLong(rightPosition, 0), rightBlock.getLong(rightPosition, 8));
    }

    private static int compareLittleEndian(long leftLow64le, long leftHigh64le, long rightLow64le, long rightHigh64le) {
        int compare = Long.compareUnsigned(Long.reverseBytes(leftLow64le), Long.reverseBytes(rightLow64le));
        if (compare != 0) {
            return compare;
        }
        return Long.compareUnsigned(Long.reverseBytes(leftHigh64le), Long.reverseBytes(rightHigh64le));
    }
}

