/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Int128ArrayBlock;

public class Int128ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "INT128_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)block;
        int positionCount = int128ArrayBlock.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, int128ArrayBlock);
        if (!int128ArrayBlock.mayHaveNull()) {
            sliceOutput.writeLongs(int128ArrayBlock.getRawValues(), int128ArrayBlock.getPositionOffset() * 2, int128ArrayBlock.getPositionCount() * 2);
        } else {
            long[] valuesWithoutNull = new long[positionCount * 2];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = int128ArrayBlock.getInt128High(i);
                valuesWithoutNull[nonNullPositionCount + 1] = int128ArrayBlock.getInt128Low(i);
                if (int128ArrayBlock.isNull(i)) continue;
                nonNullPositionCount += 2;
            }
            sliceOutput.writeInt(nonNullPositionCount / 2);
            sliceOutput.writeLongs(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public Int128ArrayBlock readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        long[] values = new long[positionCount * 2];
        if (valueIsNull == null) {
            sliceInput.readLongs(values);
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readLongs(values, 0, nonNullPositionCount * 2);
            int position = 2 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 2 * i, 2);
                if (valueIsNull[i]) continue;
                position -= 2;
            }
        }
        return new Int128ArrayBlock(0, positionCount, valueIsNull, values);
    }
}

