/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.Experimental;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public final class IntArrayBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(IntArrayBlock.class);
    public static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final int[] values;
    private final long retainedSizeInBytes;

    public IntArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, int[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    IntArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, int[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])values);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(5);
    }

    @Override
    public long getSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedPositionsCount) {
        return 5L * (long)selectedPositionsCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 4L;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf((int[])this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getInt(int position, int offset) {
        if (offset != 0) {
            throw new IllegalArgumentException("offset must be zero");
        }
        return this.getInt(position);
    }

    public int getInt(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.values[position + this.arrayOffset];
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public IntArrayBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new IntArrayBlock(0, 1, blArray, new int[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public IntArrayBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        int[] newValues = new int[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            BlockUtil.checkReadablePosition(this, position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public IntArrayBlock getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new IntArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public IntArrayBlock copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.arrayOffset, length);
        int[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new IntArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "INT_ARRAY";
    }

    @Override
    public IntArrayBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.positionCount);
        int[] newValues = BlockUtil.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1);
        return new IntArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }

    @Override
    public IntArrayBlock getUnderlyingValueBlock() {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    @Experimental(eta="2023-12-31")
    public int[] getRawValues() {
        return this.values;
    }

    @Experimental(eta="2023-12-31")
    public int getRawValuesOffset() {
        return this.arrayOffset;
    }
}

