/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.function.FunctionNullability;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Experimental(eta="2022-10-31")
public class FunctionMetadata {
    private static final String OPERATOR_PREFIX = "$operator$";
    private final FunctionId functionId;
    private final Signature signature;
    private final String canonicalName;
    private final Set<String> names;
    private final FunctionNullability functionNullability;
    private final boolean hidden;
    private final boolean deterministic;
    private final String description;
    private final FunctionKind kind;
    private final boolean deprecated;

    private FunctionMetadata(FunctionId functionId, Signature signature, String canonicalName, Set<String> names, FunctionNullability functionNullability, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.canonicalName = Objects.requireNonNull(canonicalName, "canonicalName is null");
        this.names = Set.copyOf(names);
        if (!names.contains(canonicalName)) {
            throw new IllegalArgumentException("names must contain the canonical name");
        }
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
        if (functionNullability.getArgumentNullable().size() != signature.getArgumentTypes().size()) {
            throw new IllegalArgumentException("signature and functionNullability must have same argument count");
        }
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.description = Objects.requireNonNull(description, "description is null");
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.deprecated = deprecated;
    }

    @JsonProperty
    public FunctionId getFunctionId() {
        return this.functionId;
    }

    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    @JsonProperty
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @JsonProperty
    public Set<String> getNames() {
        return this.names;
    }

    @JsonProperty
    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public FunctionKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @JsonCreator
    public static FunctionMetadata fromJson(@JsonProperty FunctionId functionId, @JsonProperty Signature signature, @JsonProperty String canonicalName, @JsonProperty Set<String> names, @JsonProperty FunctionNullability functionNullability, @JsonProperty boolean hidden, @JsonProperty boolean deterministic, @JsonProperty String description, @JsonProperty FunctionKind kind, @JsonProperty boolean deprecated) {
        return new FunctionMetadata(functionId, signature, canonicalName, names, functionNullability, hidden, deterministic, description, kind, deprecated);
    }

    public String toString() {
        return this.signature.toString();
    }

    public static Builder scalarBuilder(String canonicalName) {
        return FunctionMetadata.builder(canonicalName, FunctionKind.SCALAR);
    }

    public static Builder operatorBuilder(OperatorType operatorType) {
        String name = OPERATOR_PREFIX + Objects.requireNonNull(operatorType, "operatorType is null").name();
        return FunctionMetadata.builder(name, FunctionKind.SCALAR);
    }

    public static Builder aggregateBuilder(String canonicalName) {
        return FunctionMetadata.builder(canonicalName, FunctionKind.AGGREGATE);
    }

    public static Builder windowBuilder(String canonicalName) {
        return FunctionMetadata.builder(canonicalName, FunctionKind.WINDOW);
    }

    public static Builder builder(String canonicalName, FunctionKind functionKind) {
        return new Builder(canonicalName, functionKind);
    }

    public static final class Builder {
        private final String canonicalName;
        private final FunctionKind kind;
        private Signature signature;
        private final Set<String> names = new HashSet<String>();
        private boolean nullable;
        private List<Boolean> argumentNullability;
        private boolean hidden;
        private boolean deterministic = true;
        private String description;
        private FunctionId functionId;
        private boolean deprecated;

        private Builder(String canonicalName, FunctionKind kind) {
            this.canonicalName = Objects.requireNonNull(canonicalName, "canonicalName is null");
            this.names.add(canonicalName);
            if (canonicalName.startsWith(FunctionMetadata.OPERATOR_PREFIX)) {
                this.hidden = true;
                this.description = "";
            }
            this.kind = kind;
            if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) {
                this.nullable = true;
            }
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder alias(String alias) {
            this.names.add(alias);
            return this;
        }

        public Builder nullable() {
            this.nullable = true;
            return this;
        }

        public Builder argumentNullability(boolean ... argumentNullability) {
            Objects.requireNonNull(argumentNullability, "argumentNullability is null");
            ArrayList<Boolean> list = new ArrayList<Boolean>(argumentNullability.length);
            for (boolean nullability : argumentNullability) {
                list.add(nullability);
            }
            return this.argumentNullability(list);
        }

        public Builder argumentNullability(List<Boolean> argumentNullability) {
            this.argumentNullability = List.copyOf((Collection)Objects.requireNonNull(argumentNullability, "argumentNullability is null"));
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            if (this.description == null) {
                this.description = "";
            }
            return this;
        }

        public Builder nondeterministic() {
            this.deterministic = false;
            return this;
        }

        public Builder noDescription() {
            this.description = "";
            return this;
        }

        public Builder description(String description) {
            Objects.requireNonNull(description, "description is null");
            if (description.isBlank()) {
                throw new IllegalArgumentException("description is blank");
            }
            this.description = description;
            return this;
        }

        public Builder functionId(FunctionId functionId) {
            this.functionId = functionId;
            return this;
        }

        public Builder deprecated() {
            this.deprecated = true;
            return this;
        }

        public FunctionMetadata build() {
            FunctionId functionId = this.functionId;
            if (functionId == null) {
                functionId = FunctionId.toFunctionId(this.canonicalName, this.signature);
            }
            if (this.argumentNullability == null) {
                this.argumentNullability = Collections.nCopies(this.signature.getArgumentTypes().size(), this.kind == FunctionKind.WINDOW);
            }
            return new FunctionMetadata(functionId, this.signature, this.canonicalName, this.names, new FunctionNullability(this.nullable, this.argumentNullability), this.hidden, this.deterministic, this.description, this.kind, this.deprecated);
        }
    }
}

