/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.airlift.slice.Slice;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InternalDataAccessor;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public final class ScalarFunctionAdapter {
    private static final MethodHandle OBJECT_IS_NULL_METHOD;
    private static final MethodHandle APPEND_NULL_METHOD;
    private static final MethodHandle BLOCK_IS_NULL_METHOD;
    private static final MethodHandle IN_OUT_IS_NULL_METHOD;
    private static final MethodHandle GET_UNDERLYING_VALUE_BLOCK_METHOD;
    private static final MethodHandle GET_UNDERLYING_VALUE_POSITION_METHOD;
    private static final MethodHandle NEW_NEVER_NULL_IS_NULL_EXCEPTION;
    private static final TypeOperators READ_VALUE_TYPE_OPERATORS;

    private ScalarFunctionAdapter() {
    }

    public static boolean canAdapt(InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        Objects.requireNonNull(actualConvention, "actualConvention is null");
        Objects.requireNonNull(expectedConvention, "expectedConvention is null");
        if (actualConvention.getArgumentConventions().size() != expectedConvention.getArgumentConventions().size()) {
            throw new IllegalArgumentException("Actual and expected conventions have different number of arguments");
        }
        if (actualConvention.supportsSession() && !expectedConvention.supportsSession()) {
            return false;
        }
        if (actualConvention.supportsInstanceFactory() && !expectedConvention.supportsInstanceFactory()) {
            return false;
        }
        if (!ScalarFunctionAdapter.canAdaptReturn(actualConvention.getReturnConvention(), expectedConvention.getReturnConvention())) {
            return false;
        }
        for (int argumentIndex = 0; argumentIndex < actualConvention.getArgumentConventions().size(); ++argumentIndex) {
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention;
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(argumentIndex);
            if (ScalarFunctionAdapter.canAdaptParameter(actualArgumentConvention, expectedArgumentConvention = expectedConvention.getArgumentConvention(argumentIndex), expectedConvention.getReturnConvention())) continue;
            return false;
        }
        return true;
    }

    private static boolean canAdaptReturn(InvocationConvention.InvocationReturnConvention actualReturnConvention, InvocationConvention.InvocationReturnConvention expectedReturnConvention) {
        if (actualReturnConvention == expectedReturnConvention) {
            return true;
        }
        return switch (actualReturnConvention) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL -> {
                if (expectedReturnConvention != InvocationConvention.InvocationReturnConvention.FLAT_RETURN) {
                    yield true;
                }
                yield false;
            }
            case InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN -> {
                if (expectedReturnConvention.isNullable() || expectedReturnConvention == InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL) {
                    yield true;
                }
                yield false;
            }
            case InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationReturnConvention.FLAT_RETURN -> false;
            case InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL -> throw new IllegalArgumentException("actual return convention cannot be DEFAULT_ON_NULL");
        };
    }

    private static boolean canAdaptParameter(InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (actualArgumentConvention == expectedArgumentConvention) {
            return true;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION) {
            return false;
        }
        return switch (actualArgumentConvention) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationConvention.InvocationArgumentConvention.NEVER_NULL -> {
                switch (expectedArgumentConvention) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLOCK_POSITION_NOT_NULL: 
                    case VALUE_BLOCK_POSITION_NOT_NULL: 
                    case FLAT: {
                        yield true;
                    }
                    case BOXED_NULLABLE: 
                    case NULL_FLAG: {
                        if (returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                            yield true;
                        }
                        yield false;
                    }
                    case BLOCK_POSITION: 
                    case VALUE_BLOCK_POSITION: 
                    case IN_OUT: {
                        yield true;
                    }
                    case FUNCTION: {
                        throw new IllegalStateException("Unexpected value: " + expectedArgumentConvention);
                    }
                    case NEVER_NULL: 
                }
                yield true;
            }
            case InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL -> {
                switch (expectedArgumentConvention) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLOCK_POSITION_NOT_NULL: 
                    case VALUE_BLOCK_POSITION_NOT_NULL: {
                        yield true;
                    }
                    case BLOCK_POSITION: 
                    case VALUE_BLOCK_POSITION: {
                        if (returnConvention.isNullable() || returnConvention == InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL) {
                            yield true;
                        }
                        yield false;
                    }
                    case FLAT: 
                    case BOXED_NULLABLE: 
                    case NULL_FLAG: 
                    case IN_OUT: 
                    case NEVER_NULL: {
                        yield false;
                    }
                    case FUNCTION: 
                }
                throw new IllegalStateException("Unexpected value: " + expectedArgumentConvention);
            }
            case InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION -> {
                switch (expectedArgumentConvention) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLOCK_POSITION_NOT_NULL: 
                    case VALUE_BLOCK_POSITION_NOT_NULL: 
                    case BLOCK_POSITION: 
                    case VALUE_BLOCK_POSITION: {
                        yield true;
                    }
                    case FLAT: 
                    case BOXED_NULLABLE: 
                    case NULL_FLAG: 
                    case IN_OUT: 
                    case NEVER_NULL: {
                        yield false;
                    }
                    case FUNCTION: 
                }
                throw new IllegalStateException("Unexpected value: " + expectedArgumentConvention);
            }
            case InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.NULL_FLAG -> true;
            case InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.IN_OUT -> false;
            case InvocationConvention.InvocationArgumentConvention.FUNCTION -> throw new IllegalArgumentException("Unsupported argument convention: " + actualArgumentConvention);
        };
    }

    public static MethodHandle adapt(MethodHandle methodHandle, Type returnType, List<Type> actualArgumentTypes, InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        Objects.requireNonNull(actualConvention, "actualConvention is null");
        Objects.requireNonNull(expectedConvention, "expectedConvention is null");
        if (actualConvention.getArgumentConventions().size() != expectedConvention.getArgumentConventions().size()) {
            throw new IllegalArgumentException("Actual and expected conventions have different number of arguments");
        }
        if (actualConvention.supportsSession() && !expectedConvention.supportsSession()) {
            throw new IllegalArgumentException("Session method cannot be adapted to no session");
        }
        if (!expectedConvention.supportsInstanceFactory() && actualConvention.supportsInstanceFactory()) {
            throw new IllegalArgumentException("Instance method cannot be adapted to no instance");
        }
        methodHandle = ScalarFunctionAdapter.adaptReturn(methodHandle, returnType, actualConvention.getReturnConvention(), expectedConvention.getReturnConvention());
        int parameterIndex = 0;
        if (actualConvention.supportsInstanceFactory()) {
            ++parameterIndex;
        }
        if (actualConvention.supportsSession()) {
            ++parameterIndex;
        }
        for (int argumentIndex = 0; argumentIndex < actualConvention.getArgumentConventions().size(); ++argumentIndex) {
            Type argumentType = actualArgumentTypes.get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(argumentIndex);
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention = expectedConvention.getArgumentConvention(argumentIndex);
            methodHandle = ScalarFunctionAdapter.adaptParameter(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, expectedConvention.getReturnConvention());
            parameterIndex += expectedArgumentConvention.getParameterCount();
        }
        return methodHandle;
    }

    private static MethodHandle adaptReturn(MethodHandle methodHandle, Type returnType, InvocationConvention.InvocationReturnConvention actualReturnConvention, InvocationConvention.InvocationReturnConvention expectedReturnConvention) {
        if (actualReturnConvention == expectedReturnConvention) {
            return methodHandle;
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN && actualReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            return MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeReturnType(ScalarFunctionAdapter.wrap(methodHandle.type().returnType())));
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER) {
            methodHandle = MethodHandles.collectArguments(ScalarFunctionAdapter.writeBlockValue(returnType), 1, methodHandle);
            MethodType newType = methodHandle.type().dropParameterTypes(0, 1).appendParameterTypes(BlockBuilder.class);
            int[] reorder = IntStream.range(0, newType.parameterCount()).map(i -> i > 0 ? i - 1 : newType.parameterCount() - 1).toArray();
            methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
            return methodHandle;
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL && actualReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
            throw new IllegalArgumentException("Nullable return cannot be adapted fail on null");
        }
        if (expectedReturnConvention == InvocationConvention.InvocationReturnConvention.DEFAULT_ON_NULL) {
            if (actualReturnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                return methodHandle;
            }
            if (actualReturnConvention == InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN) {
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeReturnType(ScalarFunctionAdapter.unwrap(returnType.getJavaType())));
                return methodHandle;
            }
        }
        throw new IllegalArgumentException("%s return convention cannot be adapted to %s".formatted(new Object[]{actualReturnConvention, expectedReturnConvention}));
    }

    private static MethodHandle adaptParameter(MethodHandle methodHandle, int parameterIndex, Type argumentType, InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL && methodHandle.type().parameterType(parameterIndex) != ValueBlock.class) {
            methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(parameterIndex, ValueBlock.class));
        }
        if (actualArgumentConvention == expectedArgumentConvention) {
            return methodHandle;
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.IN_OUT) {
            throw new IllegalArgumentException("In-out argument cannot be adapted");
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION || expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.FUNCTION) {
            throw new IllegalArgumentException("Function argument cannot be adapted");
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.FLAT) {
            throw new IllegalArgumentException("Flat argument cannot be adapted");
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                if (ScalarFunctionAdapter.isWrapperType(methodHandle.type().parameterType(parameterIndex))) {
                    MethodType targetType = methodHandle.type().changeParameterType(parameterIndex, ScalarFunctionAdapter.unwrap(methodHandle.type().parameterType(parameterIndex)));
                    methodHandle = MethodHandles.explicitCastArguments(methodHandle, targetType);
                }
                return methodHandle;
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                return MethodHandles.insertArguments(methodHandle, parameterIndex + 1, false);
            }
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                Class<?> boxedType = ScalarFunctionAdapter.wrap(methodHandle.type().parameterType(parameterIndex));
                MethodType targetType = methodHandle.type().changeParameterType(parameterIndex, boxedType);
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, targetType);
                if (returnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                    throw new IllegalArgumentException("RETURN_NULL_ON_NULL adaptation cannot be used with FAIL_ON_NULL return convention");
                }
                return MethodHandles.guardWithTest(ScalarFunctionAdapter.isNullArgument(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.getNullShortCircuitResult(methodHandle, returnConvention), methodHandle);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                TypeDescriptor.OfField parameterType = methodHandle.type().parameterType(parameterIndex);
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeParameterType(parameterIndex, ScalarFunctionAdapter.wrap(parameterType)));
                methodHandle = MethodHandles.filterArguments(methodHandle, parameterIndex + 1, MethodHandles.explicitCastArguments(OBJECT_IS_NULL_METHOD, MethodType.methodType(Boolean.TYPE, ScalarFunctionAdapter.wrap(parameterType))));
                int[] reorder = IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex ? i : i - 1).toArray();
                MethodType newType = methodHandle.type().dropParameterTypes(parameterIndex + 1, parameterIndex + 2);
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
                return methodHandle;
            }
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                if (returnConvention == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                    throw new IllegalArgumentException("RETURN_NULL_ON_NULL adaptation cannot be used with FAIL_ON_NULL return convention");
                }
                methodHandle = MethodHandles.dropArguments(methodHandle, parameterIndex + 1, new Class[]{Boolean.TYPE});
                return MethodHandles.guardWithTest(ScalarFunctionAdapter.isTrueNullFlag(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.getNullShortCircuitResult(methodHandle, returnConvention), methodHandle);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                return MethodHandles.collectArguments(methodHandle, parameterIndex, ScalarFunctionAdapter.boxedToNullFlagFilter(methodHandle.type().parameterType(parameterIndex)));
            }
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION) {
                return ScalarFunctionAdapter.adaptValueBlockArgumentToBlock(methodHandle, parameterIndex);
            }
            return ScalarFunctionAdapter.adaptParameterToBlockPositionNotNull(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, returnConvention);
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION) {
                return methodHandle;
            }
            methodHandle = ScalarFunctionAdapter.adaptParameterToBlockPositionNotNull(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, returnConvention);
            methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(parameterIndex, ValueBlock.class));
            return methodHandle;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL) {
                ScalarFunctionAdapter.adaptValueBlockArgumentToBlock(methodHandle, parameterIndex);
                methodHandle = ScalarFunctionAdapter.adaptValueBlockArgumentToBlock(methodHandle, parameterIndex);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION) {
                return methodHandle;
            }
            return ScalarFunctionAdapter.adaptParameterToBlockPosition(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, returnConvention);
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION) {
            if (actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) {
                methodHandle = ScalarFunctionAdapter.adaptParameterToBlockPosition(methodHandle, parameterIndex, argumentType, actualArgumentConvention, expectedArgumentConvention, returnConvention);
            }
            methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(parameterIndex, ValueBlock.class));
            return methodHandle;
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.FLAT) {
            if (actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL && actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE && actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                throw new IllegalArgumentException(actualArgumentConvention + " cannot be adapted to " + expectedArgumentConvention);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                methodHandle = MethodHandles.insertArguments(methodHandle, parameterIndex + 1, false);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE && ScalarFunctionAdapter.isWrapperType(methodHandle.type().parameterType(parameterIndex))) {
                MethodType targetType = methodHandle.type().changeParameterType(parameterIndex, ScalarFunctionAdapter.unwrap(methodHandle.type().parameterType(parameterIndex)));
                methodHandle = MethodHandles.explicitCastArguments(methodHandle, targetType);
            }
            return MethodHandles.collectArguments(methodHandle, parameterIndex, ScalarFunctionAdapter.getFlatValueNeverNull(argumentType, methodHandle.type().parameterType(parameterIndex)));
        }
        if (expectedArgumentConvention == InvocationConvention.InvocationArgumentConvention.IN_OUT) {
            MethodHandle getInOutValue = ScalarFunctionAdapter.getInOutValue(argumentType, methodHandle.type().parameterType(parameterIndex));
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                if (returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                    methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getInOutValue);
                    return MethodHandles.guardWithTest(ScalarFunctionAdapter.isInOutNull(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.getNullShortCircuitResult(methodHandle, returnConvention), methodHandle);
                }
                MethodHandle adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isInOutNull(getInOutValue.type(), 0), ScalarFunctionAdapter.throwTrinoNullArgumentException(getInOutValue.type()), getInOutValue);
                return MethodHandles.collectArguments(methodHandle, parameterIndex, adapter);
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
                getInOutValue = MethodHandles.explicitCastArguments(getInOutValue, getInOutValue.type().changeReturnType(ScalarFunctionAdapter.wrap(getInOutValue.type().returnType())));
                getInOutValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isInOutNull(getInOutValue.type(), 0), MethodHandles.empty(getInOutValue.type()), getInOutValue);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getInOutValue);
                return methodHandle;
            }
            if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                MethodHandle isNull = ScalarFunctionAdapter.isInOutNull(getInOutValue.type(), 0);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex + 1, isNull);
                getInOutValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isInOutNull(getInOutValue.type(), 0), MethodHandles.empty(getInOutValue.type()), getInOutValue);
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getInOutValue);
                int[] reorder = IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex ? i : i - 1).toArray();
                MethodType newType = methodHandle.type().dropParameterTypes(parameterIndex + 1, parameterIndex + 2);
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
                return methodHandle;
            }
        }
        throw ScalarFunctionAdapter.unsupportedArgumentAdaptation(actualArgumentConvention, expectedArgumentConvention, returnConvention);
    }

    private static MethodHandle adaptParameterToBlockPosition(MethodHandle methodHandle, int parameterIndex, Type argumentType, InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        MethodHandle getBlockValue = ScalarFunctionAdapter.getBlockValue(argumentType, methodHandle.type().parameterType(parameterIndex));
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
            if (returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
                methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
                return MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(methodHandle.type(), parameterIndex), ScalarFunctionAdapter.getNullShortCircuitResult(methodHandle, returnConvention), methodHandle);
            }
            MethodHandle adapter = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), ScalarFunctionAdapter.throwTrinoNullArgumentException(getBlockValue.type()), getBlockValue);
            return MethodHandles.collectArguments(methodHandle, parameterIndex, adapter);
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
            getBlockValue = MethodHandles.explicitCastArguments(getBlockValue, getBlockValue.type().changeReturnType(ScalarFunctionAdapter.wrap(getBlockValue.type().returnType())));
            getBlockValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), MethodHandles.empty(getBlockValue.type()), getBlockValue);
            methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
            return methodHandle;
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
            MethodHandle isNull = ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0);
            methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex + 1, isNull);
            getBlockValue = MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(getBlockValue.type(), 0), MethodHandles.empty(getBlockValue.type()), getBlockValue);
            methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
            int[] reorder = IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex + 1 ? i : i - 2).toArray();
            MethodType newType = methodHandle.type().dropParameterTypes(parameterIndex + 2, parameterIndex + 4);
            methodHandle = MethodHandles.permuteArguments(methodHandle, newType, reorder);
            return methodHandle;
        }
        if ((actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL) && returnConvention != InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL) {
            MethodHandle nullReturnValue = ScalarFunctionAdapter.getNullShortCircuitResult(methodHandle, returnConvention);
            return MethodHandles.guardWithTest(ScalarFunctionAdapter.isBlockPositionNull(methodHandle.type(), parameterIndex), nullReturnValue, methodHandle);
        }
        throw ScalarFunctionAdapter.unsupportedArgumentAdaptation(actualArgumentConvention, expectedArgumentConvention, returnConvention);
    }

    private static MethodHandle adaptParameterToBlockPositionNotNull(MethodHandle methodHandle, int parameterIndex, Type argumentType, InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION || actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL) {
            return methodHandle;
        }
        MethodHandle getBlockValue = ScalarFunctionAdapter.getBlockValue(argumentType, methodHandle.type().parameterType(parameterIndex));
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
            return MethodHandles.collectArguments(methodHandle, parameterIndex, getBlockValue);
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE) {
            MethodType targetType = getBlockValue.type().changeReturnType(ScalarFunctionAdapter.wrap(getBlockValue.type().returnType()));
            return MethodHandles.collectArguments(methodHandle, parameterIndex, MethodHandles.explicitCastArguments(getBlockValue, targetType));
        }
        if (actualArgumentConvention == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
            return MethodHandles.collectArguments(MethodHandles.insertArguments(methodHandle, parameterIndex + 1, false), parameterIndex, getBlockValue);
        }
        throw ScalarFunctionAdapter.unsupportedArgumentAdaptation(actualArgumentConvention, expectedArgumentConvention, returnConvention);
    }

    private static IllegalArgumentException unsupportedArgumentAdaptation(InvocationConvention.InvocationArgumentConvention actualArgumentConvention, InvocationConvention.InvocationArgumentConvention expectedArgumentConvention, InvocationConvention.InvocationReturnConvention returnConvention) {
        return new IllegalArgumentException("Cannot convert argument %s to %s with return convention %s".formatted(new Object[]{actualArgumentConvention, expectedArgumentConvention, returnConvention}));
    }

    private static MethodHandle adaptValueBlockArgumentToBlock(MethodHandle methodHandle, int parameterIndex) {
        methodHandle = MethodHandles.explicitCastArguments(methodHandle, methodHandle.type().changeParameterType(parameterIndex, ValueBlock.class));
        methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex, GET_UNDERLYING_VALUE_BLOCK_METHOD);
        methodHandle = MethodHandles.collectArguments(methodHandle, parameterIndex + 1, GET_UNDERLYING_VALUE_POSITION_METHOD);
        methodHandle = MethodHandles.permuteArguments(methodHandle, methodHandle.type().dropParameterTypes(parameterIndex, parameterIndex + 1), IntStream.range(0, methodHandle.type().parameterCount()).map(i -> i <= parameterIndex ? i : i - 1).toArray());
        return methodHandle;
    }

    private static MethodHandle getBlockValue(Type argumentType, Class<?> expectedType) {
        String getterName;
        Class<Object> methodArgumentType = argumentType.getJavaType();
        if (methodArgumentType == Boolean.TYPE) {
            getterName = "getBoolean";
        } else if (methodArgumentType == Long.TYPE) {
            getterName = "getLong";
        } else if (methodArgumentType == Double.TYPE) {
            getterName = "getDouble";
        } else if (methodArgumentType == Slice.class) {
            getterName = "getSlice";
        } else {
            getterName = "getObject";
            methodArgumentType = Object.class;
        }
        try {
            MethodHandle getValue = MethodHandles.lookup().findVirtual(Type.class, getterName, MethodType.methodType(methodArgumentType, Block.class, Integer.TYPE)).bindTo(argumentType);
            return MethodHandles.explicitCastArguments(getValue, getValue.type().changeReturnType(expectedType));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle writeBlockValue(Type type) {
        String getterName;
        Class<Object> methodArgumentType = type.getJavaType();
        if (methodArgumentType == Boolean.TYPE) {
            getterName = "writeBoolean";
        } else if (methodArgumentType == Long.TYPE) {
            getterName = "writeLong";
        } else if (methodArgumentType == Double.TYPE) {
            getterName = "writeDouble";
        } else if (methodArgumentType == Slice.class) {
            getterName = "writeSlice";
        } else {
            getterName = "writeObject";
            methodArgumentType = Object.class;
        }
        try {
            return MethodHandles.lookup().findVirtual(Type.class, getterName, MethodType.methodType(Void.TYPE, BlockBuilder.class, methodArgumentType)).bindTo(type).asType(MethodType.methodType(Void.TYPE, BlockBuilder.class, type.getJavaType()));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle getFlatValueNeverNull(Type argumentType, Class<?> expectedType) {
        MethodHandle readValueOperator = READ_VALUE_TYPE_OPERATORS.getReadValueOperator(argumentType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.FLAT));
        readValueOperator = MethodHandles.explicitCastArguments(readValueOperator, readValueOperator.type().changeReturnType(expectedType));
        return readValueOperator;
    }

    private static MethodHandle getInOutValue(Type argumentType, Class<?> expectedType) {
        String getterName;
        Class<Object> methodArgumentType = argumentType.getJavaType();
        if (methodArgumentType == Boolean.TYPE) {
            getterName = "getBooleanValue";
        } else if (methodArgumentType == Long.TYPE) {
            getterName = "getLongValue";
        } else if (methodArgumentType == Double.TYPE) {
            getterName = "getDoubleValue";
        } else {
            getterName = "getObjectValue";
            methodArgumentType = Object.class;
        }
        try {
            MethodHandle getValue = MethodHandles.lookup().findVirtual(InternalDataAccessor.class, getterName, MethodType.methodType(methodArgumentType));
            return MethodHandles.explicitCastArguments(getValue, MethodType.methodType(expectedType, InOut.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle boxedToNullFlagFilter(Class<?> argumentType) {
        MethodHandle handle = MethodHandles.identity(argumentType);
        if (ScalarFunctionAdapter.isWrapperType(argumentType)) {
            handle = MethodHandles.explicitCastArguments(handle, handle.type().changeParameterType(0, ScalarFunctionAdapter.unwrap(argumentType)));
        }
        handle = MethodHandles.dropArguments(handle, 1, new Class[]{Boolean.TYPE});
        return MethodHandles.guardWithTest(ScalarFunctionAdapter.isTrueNullFlag(handle.type(), 0), MethodHandles.empty(handle.type()), handle);
    }

    private static MethodHandle isTrueNullFlag(MethodType methodType, int index) {
        return MethodHandles.permuteArguments(MethodHandles.identity(Boolean.TYPE), methodType.changeReturnType(Boolean.TYPE), index + 1);
    }

    private static MethodHandle isNullArgument(MethodType methodType, int index) {
        MethodHandle isNull = OBJECT_IS_NULL_METHOD;
        isNull = MethodHandles.explicitCastArguments(isNull, MethodType.methodType(Boolean.TYPE, methodType.parameterType(index)));
        isNull = MethodHandles.permuteArguments(isNull, methodType.changeReturnType(Boolean.TYPE), index);
        return isNull;
    }

    private static MethodHandle isBlockPositionNull(MethodType methodType, int index) {
        MethodHandle blockIsNull = BLOCK_IS_NULL_METHOD.asType(BLOCK_IS_NULL_METHOD.type().changeParameterType(0, (Class<?>)methodType.parameterType(index)));
        return MethodHandles.permuteArguments(blockIsNull, methodType.changeReturnType(Boolean.TYPE), index, index + 1);
    }

    private static MethodHandle isInOutNull(MethodType methodType, int index) {
        return MethodHandles.permuteArguments(IN_OUT_IS_NULL_METHOD, methodType.changeReturnType(Boolean.TYPE), index);
    }

    private static MethodHandle getNullShortCircuitResult(MethodHandle methodHandle, InvocationConvention.InvocationReturnConvention returnConvention) {
        if (returnConvention == InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER) {
            return MethodHandles.permuteArguments(APPEND_NULL_METHOD, methodHandle.type(), methodHandle.type().parameterCount() - 1);
        }
        return MethodHandles.empty(methodHandle.type());
    }

    private static MethodHandle throwTrinoNullArgumentException(MethodType type) {
        MethodHandle throwException = MethodHandles.collectArguments(MethodHandles.throwException(type.returnType(), TrinoException.class), 0, NEW_NEVER_NULL_IS_NULL_EXCEPTION);
        return MethodHandles.permuteArguments(throwException, type, new int[0]);
    }

    private static boolean isWrapperType(Class<?> type) {
        return type != ScalarFunctionAdapter.unwrap(type);
    }

    private static Class<?> wrap(Class<?> type) {
        return MethodType.methodType(type).wrap().returnType();
    }

    private static Class<?> unwrap(Class<?> type) {
        return MethodType.methodType(type).unwrap().returnType();
    }

    static {
        READ_VALUE_TYPE_OPERATORS = new TypeOperators();
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            OBJECT_IS_NULL_METHOD = lookup.findStatic(Objects.class, "isNull", MethodType.methodType(Boolean.TYPE, Object.class));
            APPEND_NULL_METHOD = lookup.findVirtual(BlockBuilder.class, "appendNull", MethodType.methodType(BlockBuilder.class)).asType(MethodType.methodType(Void.TYPE, BlockBuilder.class));
            BLOCK_IS_NULL_METHOD = lookup.findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
            IN_OUT_IS_NULL_METHOD = lookup.findVirtual(InOut.class, "isNull", MethodType.methodType(Boolean.TYPE));
            GET_UNDERLYING_VALUE_BLOCK_METHOD = MethodHandles.lookup().findVirtual(Block.class, "getUnderlyingValueBlock", MethodType.methodType(ValueBlock.class));
            GET_UNDERLYING_VALUE_POSITION_METHOD = MethodHandles.lookup().findVirtual(Block.class, "getUnderlyingValuePosition", MethodType.methodType(Integer.TYPE, Integer.TYPE));
            NEW_NEVER_NULL_IS_NULL_EXCEPTION = lookup.findConstructor(TrinoException.class, MethodType.methodType(Void.TYPE, ErrorCodeSupplier.class, String.class)).bindTo(StandardErrorCode.INVALID_FUNCTION_ARGUMENT).bindTo("A never null argument is null");
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

