/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.Experimental;
import io.trino.spi.function.LongVariableConstraint;
import io.trino.spi.function.TypeVariableConstraint;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Experimental(eta="2022-10-31")
public class Signature {
    private final List<TypeVariableConstraint> typeVariableConstraints;
    private final List<LongVariableConstraint> longVariableConstraints;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    private Signature(List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes, boolean variableArity) {
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        this.typeVariableConstraints = List.copyOf(typeVariableConstraints);
        this.longVariableConstraints = List.copyOf(longVariableConstraints);
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = List.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.variableArity = variableArity;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeVariableConstraint> getTypeVariableConstraints() {
        return this.typeVariableConstraints;
    }

    @JsonProperty
    public List<LongVariableConstraint> getLongVariableConstraints() {
        return this.longVariableConstraints;
    }

    public int hashCode() {
        return Objects.hash(this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.typeVariableConstraints, other.typeVariableConstraints) && Objects.equals(this.longVariableConstraints, other.longVariableConstraints) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        List allConstraints = Stream.concat(this.typeVariableConstraints.stream().map(TypeVariableConstraint::toString), this.longVariableConstraints.stream().map(LongVariableConstraint::toString)).collect(Collectors.toList());
        return (allConstraints.isEmpty() ? "" : allConstraints.stream().collect(Collectors.joining(",", "<", ">"))) + this.argumentTypes.stream().map(Objects::toString).collect(Collectors.joining(",", "(", ")")) + ":" + this.returnType;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    @JsonCreator
    public static Signature fromJson(@JsonProperty(value="typeVariableConstraints") List<TypeVariableConstraint> typeVariableConstraints, @JsonProperty(value="longVariableConstraints") List<LongVariableConstraint> longVariableConstraints, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        return new Signature(typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, variableArity);
    }

    public static final class Builder {
        private final List<TypeVariableConstraint> typeVariableConstraints = new ArrayList<TypeVariableConstraint>();
        private final List<LongVariableConstraint> longVariableConstraints = new ArrayList<LongVariableConstraint>();
        private TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private boolean variableArity;

        private Builder() {
        }

        public Builder typeVariable(String name) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).build());
            return this;
        }

        public Builder comparableTypeParameter(String name) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).comparableRequired().build());
            return this;
        }

        public Builder orderableTypeParameter(String name) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).orderableRequired().build());
            return this;
        }

        public Builder castableToTypeParameter(String name, TypeSignature toType) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).castableTo(toType).build());
            return this;
        }

        public Builder castableFromTypeParameter(String name, TypeSignature fromType) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).castableFrom(fromType).build());
            return this;
        }

        public Builder variadicTypeParameter(String name, String variadicBound) {
            this.typeVariableConstraints.add(TypeVariableConstraint.builder(name).variadicBound(variadicBound).build());
            return this;
        }

        public Builder typeVariableConstraint(TypeVariableConstraint typeVariableConstraint) {
            this.typeVariableConstraints.add(Objects.requireNonNull(typeVariableConstraint, "typeVariableConstraint is null"));
            return this;
        }

        public Builder typeVariableConstraints(List<TypeVariableConstraint> typeVariableConstraints) {
            this.typeVariableConstraints.addAll((Collection<TypeVariableConstraint>)Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null"));
            return this;
        }

        public Builder returnType(Type returnType) {
            return this.returnType(returnType.getTypeSignature());
        }

        public Builder returnType(TypeSignature returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType is null");
            return this;
        }

        public Builder longVariable(String name, String expression) {
            this.longVariableConstraints.add(new LongVariableConstraint(name, expression));
            return this;
        }

        public Builder argumentType(Type type) {
            return this.argumentType(type.getTypeSignature());
        }

        public Builder argumentType(TypeSignature type) {
            this.argumentTypes.add(Objects.requireNonNull(type, "type is null"));
            return this;
        }

        public Builder argumentTypes(List<TypeSignature> argumentTypes) {
            this.argumentTypes.addAll((Collection<TypeSignature>)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
            return this;
        }

        public Builder variableArity() {
            this.variableArity = true;
            return this;
        }

        public Signature build() {
            return new Signature(this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity);
        }
    }
}

