/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.XxHash64;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.FlatFixed;
import io.trino.spi.function.FlatFixedOffset;
import io.trino.spi.function.FlatVariableWidth;
import io.trino.spi.function.IsNull;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Optional;

public final class DoubleType
extends AbstractType
implements FixedWidthType {
    private static final TypeOperatorDeclaration TYPE_OPERATOR_DECLARATION = TypeOperatorDeclaration.extractOperatorDeclaration(DoubleType.class, MethodHandles.lookup(), Double.TYPE);
    private static final VarHandle DOUBLE_HANDLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);
    public static final DoubleType DOUBLE = new DoubleType();

    private DoubleType() {
        super(new TypeSignature("double", new TypeSignatureParameter[0]), Double.TYPE, LongArrayBlock.class);
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        return TYPE_OPERATOR_DECLARATION;
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return this.getDouble(block, position);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            LongArrayBlock valueBlock = (LongArrayBlock)block.getUnderlyingValueBlock();
            int valuePosition = block.getUnderlyingValuePosition(position);
            ((LongArrayBlockBuilder)blockBuilder).writeLong(valueBlock.getLong(valuePosition));
        }
    }

    @Override
    public double getDouble(Block block, int position) {
        return DoubleType.read((LongArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        ((LongArrayBlockBuilder)blockBuilder).writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 8));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 8);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public int getFlatFixedSize() {
        return 8;
    }

    @Override
    public boolean equals(Object other) {
        return other == DOUBLE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public Optional<Type.Range> getRange() {
        return Optional.empty();
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static double read(@BlockPosition LongArrayBlock block, @BlockIndex int position) {
        return Double.longBitsToDouble(block.getLong(position));
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static double readFlat(@FlatFixed byte[] fixedSizeSlice, @FlatFixedOffset int fixedSizeOffset, @FlatVariableWidth byte[] unusedVariableSizeSlice) {
        return DOUBLE_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
    }

    @ScalarOperator(value=OperatorType.READ_VALUE)
    private static void writeFlat(double value, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] unusedVariableSizeSlice, int unusedVariableSizeOffset) {
        DOUBLE_HANDLE.set(fixedSizeSlice, fixedSizeOffset, value);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    private static boolean equalOperator(double left, double right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    private static long hashCodeOperator(double value) {
        if (value == 0.0) {
            value = 0.0;
        }
        return AbstractLongType.hash(Double.doubleToLongBits(value));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static long xxHash64(double value) {
        if (value == 0.0) {
            value = 0.0;
        }
        return XxHash64.hash((long)Double.doubleToLongBits(value));
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    private static boolean distinctFromOperator(double left, @IsNull boolean leftNull, double right, @IsNull boolean rightNull) {
        if (leftNull || rightNull) {
            return leftNull != rightNull;
        }
        if (Double.isNaN(left) && Double.isNaN(right)) {
            return false;
        }
        return left != right;
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_LAST)
    private static long comparisonUnorderedLastOperator(double left, double right) {
        return Double.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.COMPARISON_UNORDERED_FIRST)
    private static long comparisonUnorderedFirstOperator(double left, double right) {
        if (Double.isNaN(left) && Double.isNaN(right)) {
            return 0L;
        }
        if (Double.isNaN(left)) {
            return -1L;
        }
        if (Double.isNaN(right)) {
            return 1L;
        }
        return Double.compare(left, right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    private static boolean lessThanOperator(double left, double right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    private static boolean lessThanOrEqualOperator(double left, double right) {
        return left <= right;
    }
}

