/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.Slice;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.DictionaryId;
import io.trino.spi.block.ValueBlock;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Block {
    default public int getSliceLength(int position) {
        throw new UnsupportedOperationException();
    }

    default public byte getByte(int position, int offset) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public short getShort(int position, int offset) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public int getInt(int position, int offset) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public long getLong(int position, int offset) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public Slice getSlice(int position, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public <T> T getObject(int position, Class<T> clazz) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ValueBlock getSingleValueBlock(int var1);

    public int getPositionCount();

    public long getSizeInBytes();

    default public long getLogicalSizeInBytes() {
        return this.getSizeInBytes();
    }

    public long getRegionSizeInBytes(int var1, int var2);

    public OptionalInt fixedSizeInBytesPerPosition();

    public long getPositionsSizeInBytes(boolean[] var1, int var2);

    public long getRetainedSizeInBytes();

    public long getEstimatedDataSizeForStats(int var1);

    public void retainedBytesForEachPart(ObjLongConsumer<Object> var1);

    public String getEncodingName();

    default public Block getPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        return DictionaryBlock.createInternal(offset, length, this, positions, DictionaryId.randomDictionaryId());
    }

    public Block copyPositions(int[] var1, int var2, int var3);

    public Block getRegion(int var1, int var2);

    public Block copyRegion(int var1, int var2);

    default public boolean mayHaveNull() {
        return true;
    }

    public boolean isNull(int var1);

    default public boolean isLoaded() {
        return true;
    }

    default public Block getLoadedBlock() {
        return this;
    }

    default public List<Block> getChildren() {
        return Collections.emptyList();
    }

    public Block copyWithAppendedNull();

    public ValueBlock getUnderlyingValueBlock();

    public int getUnderlyingValuePosition(int var1);
}

