/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.EncoderUtil;
import io.trino.spi.block.Fixed12Block;

public class Fixed12BlockEncoding
implements BlockEncoding {
    public static final String NAME = "FIXED12";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        Fixed12Block fixed12Block = (Fixed12Block)block;
        int positionCount = fixed12Block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, fixed12Block);
        if (!fixed12Block.mayHaveNull()) {
            sliceOutput.writeInts(fixed12Block.getRawValues(), fixed12Block.getPositionOffset() * 3, fixed12Block.getPositionCount() * 3);
        } else {
            int[] valuesWithoutNull = new int[positionCount * 3];
            int nonNullPositionCount = 0;
            for (int i = 0; i < positionCount; ++i) {
                valuesWithoutNull[nonNullPositionCount] = fixed12Block.getInt(i, 0);
                valuesWithoutNull[nonNullPositionCount + 1] = fixed12Block.getInt(i, 4);
                valuesWithoutNull[nonNullPositionCount + 2] = fixed12Block.getInt(i, 8);
                if (fixed12Block.isNull(i)) continue;
                nonNullPositionCount += 3;
            }
            sliceOutput.writeInt(nonNullPositionCount / 3);
            sliceOutput.writeInts(valuesWithoutNull, 0, nonNullPositionCount);
        }
    }

    @Override
    public Fixed12Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        int[] values = new int[positionCount * 3];
        if (valueIsNull == null) {
            sliceInput.readInts(values);
        } else {
            int nonNullPositionCount = sliceInput.readInt();
            sliceInput.readInts(values, 0, nonNullPositionCount * 3);
            int position = 3 * (nonNullPositionCount - 1);
            for (int i = positionCount - 1; i >= 0 && position >= 0; --i) {
                System.arraycopy(values, position, values, 3 * i, 3);
                if (valueIsNull[i]) continue;
                position -= 3;
            }
        }
        return new Fixed12Block(0, positionCount, valueIsNull, values);
    }
}

