/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class RowBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RowBlockBuilder.class);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private boolean[] rowIsNull;
    private final BlockBuilder[] fieldBlockBuilders;
    private final List<BlockBuilder> fieldBlockBuildersList;
    private boolean currentEntryOpened;
    private boolean hasNullRow;
    private boolean hasNonNullRow;

    public RowBlockBuilder(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, RowBlockBuilder.createFieldBlockBuilders(fieldTypes, blockBuilderStatus, expectedEntries), new boolean[expectedEntries]);
    }

    private RowBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder[] fieldBlockBuilders, boolean[] rowIsNull) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.rowIsNull = Objects.requireNonNull(rowIsNull, "rowIsNull is null");
        this.fieldBlockBuilders = Objects.requireNonNull(fieldBlockBuilders, "fieldBlockBuilders is null");
        this.fieldBlockBuildersList = List.of(fieldBlockBuilders);
    }

    private static BlockBuilder[] createFieldBlockBuilders(List<Type> fieldTypes, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        BlockBuilder[] fieldBlockBuilders = new BlockBuilder[fieldTypes.size()];
        for (int i = 0; i < fieldTypes.size(); ++i) {
            fieldBlockBuilders[i] = fieldTypes.get(i).createBlockBuilder(blockBuilderStatus, expectedEntries);
        }
        return fieldBlockBuilders;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 5L * (long)this.positionCount;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            sizeInBytes += fieldBlockBuilder.getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.rowIsNull);
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            size += fieldBlockBuilder.getRetainedSizeInBytes();
        }
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    public <E extends Throwable> void buildEntry(RowValueBuilder<E> builder) throws E {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        builder.build(this.fieldBlockBuildersList);
        this.entryAdded(false);
        this.currentEntryOpened = false;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            fieldBlockBuilder.appendNull();
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.rowIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.rowIsNull.length);
            this.rowIsNull = Arrays.copyOf(this.rowIsNull, newSize);
        }
        this.rowIsNull[this.positionCount] = isNull;
        this.hasNullRow |= isNull;
        this.hasNonNullRow |= !isNull;
        ++this.positionCount;
        for (int i = 0; i < this.fieldBlockBuilders.length; ++i) {
            if (this.fieldBlockBuilders[i].getPositionCount() == this.positionCount) continue;
            throw new IllegalStateException(String.format("field %s has unexpected position count. Expected: %s, actual: %s", i, this.positionCount, this.fieldBlockBuilders[i].getPositionCount()));
        }
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        if (!this.hasNonNullRow) {
            return this.nullRle(this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public RowBlock buildValueBlock() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        Block[] fieldBlocks = new Block[this.fieldBlockBuilders.length];
        for (int i = 0; i < this.fieldBlockBuilders.length; ++i) {
            fieldBlocks[i] = this.fieldBlockBuilders[i].build();
        }
        return RowBlock.createRowBlockInternal(this.positionCount, this.hasNullRow ? this.rowIsNull : null, fieldBlocks);
    }

    public String toString() {
        return String.format("RowBlockBuilder{numFields=%d, positionCount=%d", this.fieldBlockBuilders.length, this.getPositionCount());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        BlockBuilder[] newBlockBuilders = new BlockBuilder[this.fieldBlockBuilders.length];
        for (int i = 0; i < this.fieldBlockBuilders.length; ++i) {
            newBlockBuilders[i] = this.fieldBlockBuilders[i].newBlockBuilderLike(blockBuilderStatus);
        }
        return new RowBlockBuilder(blockBuilderStatus, newBlockBuilders, new boolean[expectedEntries]);
    }

    private Block nullRle(int length) {
        Block[] fieldBlocks = new Block[this.fieldBlockBuilders.length];
        for (int i = 0; i < this.fieldBlockBuilders.length; ++i) {
            fieldBlocks[i] = this.fieldBlockBuilders[i].newBlockBuilderLike(null).appendNull().build();
        }
        RowBlock nullRowBlock = RowBlock.createRowBlockInternal(1, new boolean[]{true}, fieldBlocks);
        return RunLengthEncodedBlock.create(nullRowBlock, length);
    }
}

