/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;

public class VariableWidthBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private final int initialSliceOutputSize;
    private SliceOutput sliceOutput = new DynamicSliceOutput(0);
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positions;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytes) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
        this.initialSliceOutputSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateArraysDataSize();
    }

    @Override
    public int getPositionCount() {
        return this.positions;
    }

    @Override
    public long getSizeInBytes() {
        long arraysSizeInBytes = 5L * (long)this.positions;
        return (long)this.sliceOutput.size() + arraysSizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.sliceOutput.getRetainedSize() + this.arraysRetainedSizeInBytes;
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    public VariableWidthBlockBuilder writeEntry(Slice source) {
        return this.writeEntry(source, 0, source.length());
    }

    public VariableWidthBlockBuilder writeEntry(Slice source, int sourceIndex, int length) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.entryAdded(length, false);
        return this;
    }

    public VariableWidthBlockBuilder writeEntry(byte[] source, int sourceIndex, int length) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        this.sliceOutput.writeBytes(source, sourceIndex, length);
        this.entryAdded(length, false);
        return this;
    }

    public <E extends Throwable> void buildEntry(VariableWidthEntryBuilder<E> builder) throws E {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        int start = this.sliceOutput.size();
        builder.build(this.sliceOutput);
        int length = this.sliceOutput.size() - start;
        this.entryAdded(length, false);
    }

    @Override
    public BlockBuilder appendNull() {
        this.hasNullValue = true;
        this.entryAdded(0, true);
        return this;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        if (!this.initialized) {
            this.initializeCapacity();
        }
        if (this.valueIsNull.length <= this.positions) {
            this.growCapacity();
        }
        this.valueIsNull[this.positions] = isNull;
        this.offsets[this.positions + 1] = this.sliceOutput.size();
        ++this.positions;
        this.hasNonNullValue |= !isNull;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    private void growCapacity() {
        int newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateArraysDataSize();
    }

    private void initializeCapacity() {
        if (this.positions != 0) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " was used before initialization");
        }
        this.initialized = true;
        this.valueIsNull = new boolean[this.initialEntryCount];
        this.offsets = new int[this.initialEntryCount + 1];
        this.sliceOutput = new DynamicSliceOutput(this.initialSliceOutputSize);
        this.updateArraysDataSize();
    }

    private void updateArraysDataSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets);
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positions);
        }
        return this.buildValueBlock();
    }

    @Override
    public VariableWidthBlock buildValueBlock() {
        return new VariableWidthBlock(0, this.positions, this.sliceOutput.slice(), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        int currentSizeInBytes = this.positions == 0 ? this.positions : this.getOffset(this.positions) - this.getOffset(0);
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedEntries, BlockUtil.calculateBlockResetBytes(currentSizeInBytes));
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positions);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append('}');
        return sb.toString();
    }

    public static interface VariableWidthEntryBuilder<E extends Throwable> {
        public void build(SliceOutput var1) throws E;
    }
}

