/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import io.trino.spi.Experimental;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.AccumulatorStateSerializer;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Experimental(eta="2022-10-31")
public class AggregationImplementation {
    private final MethodHandle inputFunction;
    private final Optional<MethodHandle> removeInputFunction;
    private final Optional<MethodHandle> combineFunction;
    private final MethodHandle outputFunction;
    private final List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors;
    private final List<Class<?>> lambdaInterfaces;

    private AggregationImplementation(MethodHandle inputFunction, Optional<MethodHandle> removeInputFunction, Optional<MethodHandle> combineFunction, MethodHandle outputFunction, List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors, List<Class<?>> lambdaInterfaces) {
        this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
        this.removeInputFunction = Objects.requireNonNull(removeInputFunction, "removeInputFunction is null");
        this.combineFunction = Objects.requireNonNull(combineFunction, "combineFunction is null");
        this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
        this.accumulatorStateDescriptors = Objects.requireNonNull(accumulatorStateDescriptors, "accumulatorStateDescriptors is null");
        this.lambdaInterfaces = List.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
    }

    public MethodHandle getInputFunction() {
        return this.inputFunction;
    }

    public Optional<MethodHandle> getRemoveInputFunction() {
        return this.removeInputFunction;
    }

    public Optional<MethodHandle> getCombineFunction() {
        return this.combineFunction;
    }

    public MethodHandle getOutputFunction() {
        return this.outputFunction;
    }

    public List<AccumulatorStateDescriptor<?>> getAccumulatorStateDescriptors() {
        return this.accumulatorStateDescriptors;
    }

    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MethodHandle inputFunction;
        private Optional<MethodHandle> removeInputFunction = Optional.empty();
        private Optional<MethodHandle> combineFunction = Optional.empty();
        private MethodHandle outputFunction;
        private List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors = new ArrayList();
        private List<Class<?>> lambdaInterfaces = List.of();

        private Builder() {
        }

        public Builder inputFunction(MethodHandle inputFunction) {
            this.inputFunction = Objects.requireNonNull(inputFunction, "inputFunction is null");
            return this;
        }

        public Builder removeInputFunction(MethodHandle removeInputFunction) {
            this.removeInputFunction = Optional.of(Objects.requireNonNull(removeInputFunction, "removeInputFunction is null"));
            return this;
        }

        public Builder combineFunction(MethodHandle combineFunction) {
            this.combineFunction = Optional.of(Objects.requireNonNull(combineFunction, "combineFunction is null"));
            return this;
        }

        public Builder outputFunction(MethodHandle outputFunction) {
            this.outputFunction = Objects.requireNonNull(outputFunction, "outputFunction is null");
            return this;
        }

        public <T extends AccumulatorState> Builder accumulatorStateDescriptor(Class<T> stateInterface, AccumulatorStateSerializer<T> serializer, AccumulatorStateFactory<T> factory) {
            this.accumulatorStateDescriptors.add(AccumulatorStateDescriptor.builder(stateInterface).serializer(serializer).factory(factory).build());
            return this;
        }

        public Builder accumulatorStateDescriptors(List<AccumulatorStateDescriptor<?>> accumulatorStateDescriptors) {
            Objects.requireNonNull(accumulatorStateDescriptors, "accumulatorStateDescriptors is null");
            this.accumulatorStateDescriptors = new ArrayList();
            this.accumulatorStateDescriptors.addAll(accumulatorStateDescriptors);
            return this;
        }

        public Builder lambdaInterfaces(Class<?> ... lambdaInterfaces) {
            return this.lambdaInterfaces(List.of(lambdaInterfaces));
        }

        public Builder lambdaInterfaces(List<Class<?>> lambdaInterfaces) {
            this.lambdaInterfaces = List.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
            return this;
        }

        public AggregationImplementation build() {
            return new AggregationImplementation(this.inputFunction, this.removeInputFunction, this.combineFunction, this.outputFunction, this.accumulatorStateDescriptors, this.lambdaInterfaces);
        }
    }

    public static class AccumulatorStateDescriptor<T extends AccumulatorState> {
        private final Class<T> stateInterface;
        private final AccumulatorStateSerializer<T> serializer;
        private final AccumulatorStateFactory<T> factory;

        private AccumulatorStateDescriptor(Class<T> stateInterface, AccumulatorStateSerializer<T> serializer, AccumulatorStateFactory<T> factory) {
            this.stateInterface = Objects.requireNonNull(stateInterface, "stateInterface is null");
            this.serializer = Objects.requireNonNull(serializer, "serializer is null");
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public Class<T> getStateInterface() {
            return this.stateInterface;
        }

        public AccumulatorStateSerializer<T> getSerializer() {
            return this.serializer;
        }

        public AccumulatorStateFactory<T> getFactory() {
            return this.factory;
        }

        public static <T extends AccumulatorState> Builder<T> builder(Class<T> stateInterface) {
            return new Builder<T>(stateInterface);
        }

        public static class Builder<T extends AccumulatorState> {
            private final Class<T> stateInterface;
            private AccumulatorStateSerializer<T> serializer;
            private AccumulatorStateFactory<T> factory;

            private Builder(Class<T> stateInterface) {
                this.stateInterface = Objects.requireNonNull(stateInterface, "stateInterface is null");
            }

            public Builder<T> serializer(AccumulatorStateSerializer<T> serializer) {
                this.serializer = serializer;
                return this;
            }

            public Builder<T> factory(AccumulatorStateFactory<T> factory) {
                this.factory = factory;
                return this;
            }

            public AccumulatorStateDescriptor<T> build() {
                return new AccumulatorStateDescriptor<T>(this.stateInterface, this.serializer, this.factory);
            }
        }
    }
}

