/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class InvocationConvention {
    private final List<InvocationArgumentConvention> argumentConventionList;
    private final InvocationReturnConvention returnConvention;
    private final boolean supportsSession;
    private final boolean supportsInstanceFactory;

    public static InvocationConvention simpleConvention(InvocationReturnConvention returnConvention, InvocationArgumentConvention ... argumentConventions) {
        return new InvocationConvention(Arrays.asList(argumentConventions), returnConvention, false, false);
    }

    public InvocationConvention(List<InvocationArgumentConvention> argumentConventionList, InvocationReturnConvention returnConvention, boolean supportsSession, boolean supportsInstanceFactory) {
        this.argumentConventionList = List.copyOf((Collection)Objects.requireNonNull(argumentConventionList, "argumentConventionList is null"));
        this.returnConvention = returnConvention;
        this.supportsSession = supportsSession;
        this.supportsInstanceFactory = supportsInstanceFactory;
    }

    public InvocationReturnConvention getReturnConvention() {
        return this.returnConvention;
    }

    public List<InvocationArgumentConvention> getArgumentConventions() {
        return this.argumentConventionList;
    }

    public InvocationArgumentConvention getArgumentConvention(int index) {
        return this.argumentConventionList.get(index);
    }

    public boolean supportsSession() {
        return this.supportsSession;
    }

    @Deprecated
    public boolean supportsInstanceFactor() {
        return this.supportsInstanceFactory();
    }

    public boolean supportsInstanceFactory() {
        return this.supportsInstanceFactory;
    }

    public String toString() {
        return "(" + this.argumentConventionList.toString() + ")" + this.returnConvention;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvocationConvention that = (InvocationConvention)o;
        return this.supportsSession == that.supportsSession && this.supportsInstanceFactory == that.supportsInstanceFactory && Objects.equals(this.argumentConventionList, that.argumentConventionList) && this.returnConvention == that.returnConvention;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argumentConventionList, this.returnConvention, this.supportsSession, this.supportsInstanceFactory});
    }

    public static enum InvocationReturnConvention {
        FAIL_ON_NULL(false, 0),
        DEFAULT_ON_NULL(false, 0),
        NULLABLE_RETURN(true, 0),
        BLOCK_BUILDER(true, 1),
        FLAT_RETURN(false, 4);

        private final boolean nullable;
        private final int parameterCount;

        private InvocationReturnConvention(boolean nullable, int parameterCount) {
            this.nullable = nullable;
            this.parameterCount = parameterCount;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }
    }

    public static enum InvocationArgumentConvention {
        NEVER_NULL(false, 1),
        BLOCK_POSITION_NOT_NULL(false, 2),
        VALUE_BLOCK_POSITION_NOT_NULL(false, 2),
        BOXED_NULLABLE(true, 1),
        NULL_FLAG(true, 2),
        BLOCK_POSITION(true, 2),
        VALUE_BLOCK_POSITION(true, 2),
        FLAT(false, 3),
        IN_OUT(true, 1),
        FUNCTION(false, 1);

        private final boolean nullable;
        private final int parameterCount;

        private InvocationArgumentConvention(boolean nullable, int parameterCount) {
            this.nullable = nullable;
            this.parameterCount = parameterCount;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }
    }
}

