/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.LongTimeWithTimeZoneType;
import io.trino.spi.type.ShortTimeWithTimeZoneType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TimeWithTimeZoneType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 9;
    public static final int DEFAULT_PRECISION = 3;
    private static final TimeWithTimeZoneType[] TYPES = new TimeWithTimeZoneType[13];
    public static final TimeWithTimeZoneType TIME_TZ_SECONDS;
    public static final TimeWithTimeZoneType TIME_TZ_MILLIS;
    public static final TimeWithTimeZoneType TIME_TZ_MICROS;
    public static final TimeWithTimeZoneType TIME_TZ_NANOS;
    public static final TimeWithTimeZoneType TIME_TZ_PICOS;
    @Deprecated
    public static final TimeWithTimeZoneType TIME_WITH_TIME_ZONE;
    private final int precision;

    public static TimeWithTimeZoneType createTimeWithTimeZoneType(int precision) {
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIME WITH TIME ZONE precision must be in range [0, %s]: %s", 12, precision));
        }
        return TYPES[precision];
    }

    protected TimeWithTimeZoneType(int precision, Class<?> javaType, Class<? extends ValueBlock> valueBlockType) {
        super(new TypeSignature("time with time zone", TypeSignatureParameter.numericParameter(precision)), javaType, valueBlockType);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 9;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }

    static {
        for (int precision = 0; precision <= 12; ++precision) {
            TimeWithTimeZoneType.TYPES[precision] = precision <= 9 ? new ShortTimeWithTimeZoneType(precision) : new LongTimeWithTimeZoneType(precision);
        }
        TIME_TZ_SECONDS = TimeWithTimeZoneType.createTimeWithTimeZoneType(0);
        TIME_TZ_MILLIS = TimeWithTimeZoneType.createTimeWithTimeZoneType(3);
        TIME_TZ_MICROS = TimeWithTimeZoneType.createTimeWithTimeZoneType(6);
        TIME_TZ_NANOS = TimeWithTimeZoneType.createTimeWithTimeZoneType(9);
        TIME_TZ_PICOS = TimeWithTimeZoneType.createTimeWithTimeZoneType(12);
        TIME_WITH_TIME_ZONE = TIME_TZ_MILLIS;
    }
}

