/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;

public class Int128ArrayBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Int128ArrayBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new Int128ArrayBlock(0, 1, new boolean[]{true}, new long[2]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public Int128ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    public void writeInt128(long high, long low) {
        this.ensureCapacity(this.positionCount + 1);
        int valueIndex = this.positionCount * 2;
        this.values[valueIndex] = high;
        this.values[valueIndex + 1] = low;
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(17);
        }
    }

    @Override
    public void append(ValueBlock block, int position) {
        this.ensureCapacity(this.positionCount + 1);
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)block;
        if (int128ArrayBlock.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            long[] rawValues = int128ArrayBlock.getRawValues();
            int rawValuePosition = (int128ArrayBlock.getRawOffset() + position) * 2;
            int positionIndex = this.positionCount * 2;
            this.values[positionIndex] = rawValues[rawValuePosition];
            this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(17);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.append(block, position);
            return;
        }
        this.ensureCapacity(this.positionCount + count);
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)block;
        if (int128ArrayBlock.isNull(position)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + count, true);
            this.hasNullValue = true;
        } else {
            long[] rawValues = int128ArrayBlock.getRawValues();
            int rawValuePosition = (int128ArrayBlock.getRawOffset() + position) * 2;
            long valueHigh = rawValues[rawValuePosition];
            long valueLow = rawValues[rawValuePosition + 1];
            int positionIndex = this.positionCount * 2;
            for (int i = 0; i < count; ++i) {
                this.values[positionIndex] = valueHigh;
                this.values[positionIndex + 1] = valueLow;
                positionIndex += 2;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += count;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(count * 17);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, offset);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)block;
        int rawOffset = int128ArrayBlock.getRawOffset();
        long[] rawValues = int128ArrayBlock.getRawValues();
        System.arraycopy(rawValues, (rawOffset + offset) * 2, this.values, this.positionCount * 2, length * 2);
        boolean[] rawValueIsNull = int128ArrayBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                if (rawValueIsNull[rawOffset + offset + i]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 9);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, positions[offset]);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)block;
        int rawOffset = int128ArrayBlock.getRawOffset();
        long[] rawValues = int128ArrayBlock.getRawValues();
        boolean[] rawValueIsNull = int128ArrayBlock.getRawValueIsNull();
        int positionIndex = this.positionCount * 2;
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                if (rawValueIsNull[rawPosition]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                } else {
                    int rawValuePosition = rawPosition * 2;
                    this.values[positionIndex] = rawValues[rawValuePosition];
                    this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
                    this.hasNonNullValue = true;
                }
                positionIndex += 2;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                int rawValuePosition = rawPosition * 2;
                this.values[positionIndex] = rawValues[rawValuePosition];
                this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
                positionIndex += 2;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 17);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        this.ensureCapacity(this.positionCount + 1);
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(17);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public Int128ArrayBlock buildValueBlock() {
        return new Int128ArrayBlock(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new Int128ArrayBlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(capacity);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize * 2);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 17L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Int128ArrayBlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

