/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.google.errorprone.annotations.FormatMethod;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.LongDecimalType;
import io.trino.spi.type.ShortDecimalType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DecimalType
extends AbstractType
implements FixedWidthType {
    public static final int DEFAULT_SCALE = 0;
    public static final int DEFAULT_PRECISION = 38;
    private final int precision;
    private final int scale;

    public static DecimalType createDecimalType(int precision, int scale) {
        if (precision <= 0 || precision > 38) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("DECIMAL precision must be in range [1, %d]: %s", 38, precision));
        }
        if (scale < 0 || scale > precision) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("DECIMAL scale must be in range [0, precision (%s)]: %s", precision, scale));
        }
        if (precision <= 18) {
            return ShortDecimalType.getInstance(precision, scale);
        }
        return new LongDecimalType(precision, scale);
    }

    public static DecimalType createDecimalType(int precision) {
        return DecimalType.createDecimalType(precision, 0);
    }

    public static DecimalType createDecimalType() {
        return DecimalType.createDecimalType(38, 0);
    }

    DecimalType(int precision, int scale, Class<?> javaType, Class<? extends ValueBlock> valueBlockType) {
        super(new TypeSignature("decimal", DecimalType.buildTypeParameters(precision, scale)), javaType, valueBlockType);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public final boolean isComparable() {
        return true;
    }

    @Override
    public final boolean isOrderable() {
        return true;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isShort() {
        return this.precision <= 18;
    }

    private static List<TypeSignatureParameter> buildTypeParameters(int precision, int scale) {
        return List.of(TypeSignatureParameter.numericParameter(precision), TypeSignatureParameter.numericParameter(scale));
    }

    @FormatMethod
    static void checkArgument(boolean condition, String format, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(format, args));
        }
    }
}

