/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.LongTimestampType;
import io.trino.spi.type.ShortTimestampType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TimestampType
extends AbstractType
implements FixedWidthType {
    public static final int MAX_PRECISION = 12;
    public static final int MAX_SHORT_PRECISION = 6;
    public static final int DEFAULT_PRECISION = 3;
    private static final TimestampType[] TYPES = new TimestampType[13];
    public static final TimestampType TIMESTAMP_SECONDS;
    public static final TimestampType TIMESTAMP_MILLIS;
    public static final TimestampType TIMESTAMP_MICROS;
    public static final TimestampType TIMESTAMP_NANOS;
    public static final TimestampType TIMESTAMP_PICOS;
    private final int precision;

    public static TimestampType createTimestampType(int precision) {
        if (precision < 0 || precision > 12) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("TIMESTAMP precision must be in range [0, %s]: %s", 12, precision));
        }
        return TYPES[precision];
    }

    TimestampType(int precision, Class<?> javaType, Class<? extends ValueBlock> valueBlockType) {
        super(new TypeSignature("timestamp", TypeSignatureParameter.numericParameter(precision)), javaType, valueBlockType);
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public final boolean isShort() {
        return this.precision <= 6;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    static {
        for (int precision = 0; precision <= 12; ++precision) {
            TimestampType.TYPES[precision] = precision <= 6 ? new ShortTimestampType(precision) : new LongTimestampType(precision);
        }
        TIMESTAMP_SECONDS = TimestampType.createTimestampType(0);
        TIMESTAMP_MILLIS = TimestampType.createTimestampType(3);
        TIMESTAMP_MICROS = TimestampType.createTimestampType(6);
        TIMESTAMP_NANOS = TimestampType.createTimestampType(9);
        TIMESTAMP_PICOS = TimestampType.createTimestampType(12);
    }
}

