/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;

public class Fixed12BlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(Fixed12BlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new Fixed12Block(0, 1, new boolean[]{true}, new int[3]);
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] values = new int[0];
    private long retainedSizeInBytes;

    public Fixed12BlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    public void writeFixed12(long first, int second) {
        this.ensureCapacity(this.positionCount + 1);
        Fixed12Block.encodeFixed12(first, second, this.values, this.positionCount);
        this.hasNonNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
    }

    @Override
    public void append(ValueBlock block, int position) {
        this.ensureCapacity(this.positionCount + 1);
        Fixed12Block fixed12Block = (Fixed12Block)block;
        if (fixed12Block.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            int[] rawValues = fixed12Block.getRawValues();
            int rawValuePosition = (fixed12Block.getRawOffset() + position) * 3;
            int positionIndex = this.positionCount * 3;
            this.values[positionIndex] = rawValues[rawValuePosition];
            this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
            this.values[positionIndex + 2] = rawValues[rawValuePosition + 2];
            this.hasNonNullValue = true;
        }
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.append(block, position);
            return;
        }
        this.ensureCapacity(this.positionCount + count);
        Fixed12Block fixed12Block = (Fixed12Block)block;
        if (fixed12Block.isNull(position)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + count, true);
            this.hasNullValue = true;
        } else {
            int[] rawValues = fixed12Block.getRawValues();
            int rawValuePosition = (fixed12Block.getRawOffset() + position) * 3;
            int valueFirst = rawValues[rawValuePosition];
            int valueSecond = rawValues[rawValuePosition + 1];
            int valueThird = rawValues[rawValuePosition + 2];
            int positionIndex = this.positionCount * 3;
            for (int i = 0; i < count; ++i) {
                this.values[positionIndex] = valueFirst;
                this.values[positionIndex + 1] = valueSecond;
                this.values[positionIndex + 2] = valueThird;
                positionIndex += 3;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += count;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(count * 13);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, offset);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        Fixed12Block fixed12Block = (Fixed12Block)block;
        int rawOffset = fixed12Block.getRawOffset();
        int[] rawValues = fixed12Block.getRawValues();
        System.arraycopy(rawValues, (rawOffset + offset) * 3, this.values, this.positionCount * 3, length * 3);
        boolean[] rawValueIsNull = fixed12Block.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                if (rawValueIsNull[rawOffset + offset + i]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 9);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, positions[offset]);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        Fixed12Block fixed12Block = (Fixed12Block)block;
        int rawOffset = fixed12Block.getRawOffset();
        int[] rawValues = fixed12Block.getRawValues();
        boolean[] rawValueIsNull = fixed12Block.getRawValueIsNull();
        int positionIndex = this.positionCount * 3;
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                if (rawValueIsNull[rawPosition]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                } else {
                    int rawValuePosition = rawPosition * 3;
                    this.values[positionIndex] = rawValues[rawValuePosition];
                    this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
                    this.values[positionIndex + 2] = rawValues[rawValuePosition + 2];
                    this.hasNonNullValue = true;
                }
                positionIndex += 3;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawOffset;
                int rawValuePosition = rawPosition * 3;
                this.values[positionIndex] = rawValues[rawValuePosition];
                this.values[positionIndex + 1] = rawValues[rawValuePosition + 1];
                this.values[positionIndex + 2] = rawValues[rawValuePosition + 2];
                positionIndex += 3;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 13);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        this.ensureCapacity(this.positionCount + 1);
        this.valueIsNull[this.positionCount] = true;
        this.hasNullValue = true;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(13);
        }
        return this;
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public Fixed12Block buildValueBlock() {
        return new Fixed12Block(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.values);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        return new Fixed12BlockBuilder(blockBuilderStatus, expectedEntries);
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(capacity);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.values = Arrays.copyOf(this.values, newSize * 3);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.values);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public long getSizeInBytes() {
        return 13L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Fixed12BlockBuilder{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }
}

