/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.IntArrayList;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public final class ArrayBlock
implements ValueBlock {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ArrayBlock.class);
    private final int arrayOffset;
    private final int positionCount;
    private final boolean[] valueIsNull;
    private final Block values;
    private final int[] offsets;
    private volatile long sizeInBytes;
    private final long retainedSizeInBytes;

    public static ArrayBlock fromElementBlock(int positionCount, Optional<boolean[]> valueIsNullOptional, int[] arrayOffset, Block values) {
        boolean[] valueIsNull = valueIsNullOptional.orElse(null);
        ArrayBlock.validateConstructorArguments(0, positionCount, valueIsNull, arrayOffset, values);
        for (int i = 0; i < positionCount; ++i) {
            int offset = arrayOffset[i];
            int length = arrayOffset[i + 1] - offset;
            if (length < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, arrayOffset[i], i + 1, arrayOffset[i + 1]));
            }
            if (valueIsNull == null || !valueIsNull[i] || length == 0) continue;
            throw new IllegalArgumentException("A null array must have zero entries");
        }
        return new ArrayBlock(0, positionCount, valueIsNull, arrayOffset, values);
    }

    static ArrayBlock createArrayBlockInternal(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        ArrayBlock.validateConstructorArguments(arrayOffset, positionCount, valueIsNull, offsets, values);
        return new ArrayBlock(arrayOffset, positionCount, valueIsNull, offsets, values);
    }

    private static void validateConstructorArguments(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        Objects.requireNonNull(offsets, "offsets is null");
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        Objects.requireNonNull(values, "values is null");
    }

    private ArrayBlock(int arrayOffset, int positionCount, @Nullable boolean[] valueIsNull, int[] offsets, Block values) {
        this.arrayOffset = arrayOffset;
        this.positionCount = positionCount;
        this.valueIsNull = valueIsNull;
        this.offsets = offsets;
        this.values = Objects.requireNonNull(values);
        this.sizeInBytes = -1L;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])offsets) + SizeOf.sizeOf((boolean[])valueIsNull);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        if (this.sizeInBytes < 0L) {
            if (!this.values.isLoaded()) {
                return this.getBaseSizeInBytes();
            }
            this.calculateSize();
        }
        return this.sizeInBytes;
    }

    private void calculateSize() {
        int valueStart = this.offsets[this.arrayOffset];
        int valueEnd = this.offsets[this.arrayOffset + this.positionCount];
        this.sizeInBytes = this.values.getRegionSizeInBytes(valueStart, valueEnd - valueStart) + this.getBaseSizeInBytes();
    }

    private long getBaseSizeInBytes() {
        return 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.values.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.values, this.values.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    Block getRawElementBlock() {
        return this.values;
    }

    int[] getOffsets() {
        return this.offsets;
    }

    boolean[] getRawValueIsNull() {
        return this.valueIsNull;
    }

    int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    public String getEncodingName() {
        return "ARRAY";
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    public String toString() {
        return "ArrayBlock{positionCount=" + this.getPositionCount() + "}";
    }

    @Override
    public boolean isLoaded() {
        return this.values.isLoaded();
    }

    @Override
    public ArrayBlock getLoadedBlock() {
        Block loadedValuesBlock = this.values.getLoadedBlock();
        if (loadedValuesBlock == this.values) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(this.arrayOffset, this.positionCount, this.valueIsNull, this.offsets, loadedValuesBlock);
    }

    @Override
    public ArrayBlock copyWithAppendedNull() {
        boolean[] newValueIsNull = BlockUtil.copyIsNullAndAppendNull(this.valueIsNull, this.arrayOffset, this.getPositionCount());
        int[] newOffsets = BlockUtil.copyOffsetsAndAppendNull(this.offsets, this.arrayOffset, this.getPositionCount());
        return ArrayBlock.createArrayBlockInternal(this.arrayOffset, this.getPositionCount() + 1, newValueIsNull, newOffsets, this.values);
    }

    @Override
    public ArrayBlock copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        newOffsets[0] = 0;
        boolean[] newValueIsNull = this.valueIsNull == null ? null : new boolean[length];
        IntArrayList valuesPositions = new IntArrayList();
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (newValueIsNull != null && this.isNull(position)) {
                newValueIsNull[i] = true;
                newOffsets[i + 1] = newOffsets[i];
                continue;
            }
            int valuesStartOffset = this.offsets[position + this.arrayOffset];
            int valuesEndOffset = this.offsets[position + 1 + this.arrayOffset];
            int valuesLength = valuesEndOffset - valuesStartOffset;
            newOffsets[i + 1] = newOffsets[i] + valuesLength;
            for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                valuesPositions.add(elementIndex);
            }
        }
        Block newValues = this.values.copyPositions(valuesPositions.elements(), 0, valuesPositions.size());
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public ArrayBlock getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return ArrayBlock.createArrayBlockInternal(position + this.arrayOffset, length, this.valueIsNull, this.offsets, this.values);
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.offsets[this.arrayOffset + position];
        int valueEnd = this.offsets[this.arrayOffset + position + length];
        return this.values.getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int selectedArrayPositions) {
        long sizeInBytes;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        if (selectedArrayPositions == 0) {
            return 0L;
        }
        if (selectedArrayPositions == positionCount) {
            return this.getSizeInBytes();
        }
        Block rawElementBlock = this.values;
        OptionalInt fixedPerElementSizeInBytes = rawElementBlock.fixedSizeInBytesPerPosition();
        int[] offsets = this.offsets;
        int offsetBase = this.arrayOffset;
        if (fixedPerElementSizeInBytes.isPresent()) {
            sizeInBytes = (long)fixedPerElementSizeInBytes.getAsInt() * (long)BlockUtil.countSelectedPositionsFromOffsets(positions, offsets, offsetBase);
        } else if (rawElementBlock instanceof RunLengthEncodedBlock) {
            sizeInBytes = rawElementBlock.getPositionsSizeInBytes(null, BlockUtil.countSelectedPositionsFromOffsets(positions, offsets, offsetBase));
        } else {
            boolean[] selectedElements = new boolean[rawElementBlock.getPositionCount()];
            int selectedElementCount = BlockUtil.countAndMarkSelectedPositionsFromOffsets(positions, offsets, offsetBase, selectedElements);
            sizeInBytes = rawElementBlock.getPositionsSizeInBytes(selectedElements, selectedElementCount);
        }
        return sizeInBytes + 5L * (long)selectedArrayPositions;
    }

    @Override
    public ArrayBlock copyRegion(int position, int length) {
        boolean[] newValueIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.offsets[position + this.arrayOffset];
        int endValueOffset = this.offsets[position + length + this.arrayOffset];
        Block newValues = this.values.copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, position + this.arrayOffset, length);
        boolean[] valueIsNull = this.valueIsNull;
        boolean[] blArray = newValueIsNull = valueIsNull == null ? null : BlockUtil.compactArray(valueIsNull, position + this.arrayOffset, length);
        if (newValues == this.values && newOffsets == this.offsets && newValueIsNull == valueIsNull) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    public Block getArray(int position) {
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.offsets[position + this.arrayOffset];
        int endValueOffset = this.offsets[position + 1 + this.arrayOffset];
        return this.values.getRegion(startValueOffset, endValueOffset - startValueOffset);
    }

    @Override
    public ArrayBlock getSingleValueBlock(int position) {
        boolean[] blArray;
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.offsets[position + this.arrayOffset];
        int valueLength = this.offsets[position + 1 + this.arrayOffset] - startValueOffset;
        Block newValues = this.values.copyRegion(startValueOffset, valueLength);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return ArrayBlock.createArrayBlockInternal(0, 1, blArray, new int[]{0, valueLength}, newValues);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        BlockUtil.checkReadablePosition(this, position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.offsets[position + this.arrayOffset];
        int endValueOffset = this.offsets[position + 1 + this.arrayOffset];
        Block rawElementBlock = this.values;
        long size = 0L;
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawElementBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        BlockUtil.checkReadablePosition(this, position);
        boolean[] valueIsNull = this.valueIsNull;
        return valueIsNull != null && valueIsNull[position + this.arrayOffset];
    }

    @Override
    public ArrayBlock getUnderlyingValueBlock() {
        return this;
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        BlockUtil.checkReadablePosition(this, position);
        int startValueOffset = this.offsets[position + this.arrayOffset];
        int endValueOffset = this.offsets[position + 1 + this.arrayOffset];
        return function.apply(this.values, startValueOffset, endValueOffset - startValueOffset);
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

