/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.transaction;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;

public enum IsolationLevel {
    SERIALIZABLE,
    REPEATABLE_READ,
    READ_COMMITTED,
    READ_UNCOMMITTED;


    public boolean meetsRequirementOf(IsolationLevel requirement) {
        switch (this.ordinal()) {
            case 3: {
                return requirement == READ_UNCOMMITTED;
            }
            case 2: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED;
            }
            case 1: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED || requirement == REPEATABLE_READ;
            }
            case 0: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + String.valueOf((Object)this)));
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }

    public static void checkConnectorSupports(IsolationLevel supportedLevel, IsolationLevel requestedLevel) {
        if (!supportedLevel.meetsRequirementOf(requestedLevel)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ISOLATION_LEVEL, String.format("Connector supported isolation level %s does not meet requested isolation level %s", new Object[]{supportedLevel, requestedLevel}));
        }
    }
}

