/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MapType
extends AbstractType {
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final MethodHandle NOT;
    private static final InvocationConvention READ_FLAT_CONVENTION;
    private static final InvocationConvention READ_FLAT_TO_BLOCK_CONVENTION;
    private static final InvocationConvention WRITE_FLAT_CONVENTION;
    private static final InvocationConvention EQUAL_CONVENTION;
    private static final InvocationConvention HASH_CODE_CONVENTION;
    private static final InvocationConvention DISTINCT_FROM_CONVENTION;
    private static final InvocationConvention INDETERMINATE_CONVENTION;
    private static final MethodHandle READ_FLAT;
    private static final MethodHandle READ_FLAT_TO_BLOCK;
    private static final MethodHandle WRITE_FLAT;
    private static final MethodHandle EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle SEEK_KEY;
    private static final MethodHandle DISTINCT_FROM;
    private static final MethodHandle INDETERMINATE;
    private final Type keyType;
    private final Type valueType;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final MethodHandle keyBlockNativeNotDistinctFrom;
    private final MethodHandle keyBlockNotDistinctFrom;
    private final MethodHandle keyNativeHashCode;
    private final MethodHandle keyBlockHashCode;
    private final MethodHandle keyBlockNativeEqual;
    private final MethodHandle keyBlockEqual;
    private volatile TypeOperatorDeclaration typeOperatorDeclaration;

    public MapType(Type keyType, Type valueType, TypeOperators typeOperators) {
        super(new TypeSignature("map", TypeSignatureParameter.typeParameter(keyType.getTypeSignature()), TypeSignatureParameter.typeParameter(valueType.getTypeSignature())), SqlMap.class, MapBlock.class);
        if (!keyType.isComparable()) {
            throw new IllegalArgumentException(String.format("key type must be comparable, got %s", keyType));
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyBlockNativeEqual = typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL)).asType(MethodType.methodType(Boolean.class, Block.class, Integer.TYPE, keyType.getJavaType().isPrimitive() ? keyType.getJavaType() : Object.class));
        this.keyBlockEqual = typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        this.keyBlockNativeNotDistinctFrom = MethodHandles.filterReturnValue(typeOperators.getDistinctFromOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.NEVER_NULL)), NOT).asType(MethodType.methodType(Boolean.TYPE, Block.class, Integer.TYPE, keyType.getJavaType().isPrimitive() ? keyType.getJavaType() : Object.class));
        this.keyBlockNotDistinctFrom = MethodHandles.filterReturnValue(typeOperators.getDistinctFromOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)), NOT);
        this.keyNativeHashCode = typeOperators.getHashCodeOperator(keyType, HASH_CODE_CONVENTION).asType(MethodType.methodType(Long.TYPE, keyType.getJavaType().isPrimitive() ? keyType.getJavaType() : Object.class));
        this.keyBlockHashCode = typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.typeOperatorDeclaration;
    }

    private synchronized void generateTypeOperators(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration != null) {
            return;
        }
        if (!this.valueType.isComparable()) {
            this.typeOperatorDeclaration = TypeOperatorDeclaration.NO_TYPE_OPERATOR_DECLARATION;
        }
        this.typeOperatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addReadValueOperators(MapType.getReadValueOperatorMethodHandles(typeOperators, this)).addEqualOperator(MapType.getEqualOperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addHashCodeOperator(MapType.getHashCodeOperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addXxHash64Operator(MapType.getXxHash64OperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addDistinctFromOperator(MapType.getDistinctFromOperatorInvoker(typeOperators, this.keyType, this.valueType)).addIndeterminateOperator(MapType.getIndeterminateOperatorInvoker(typeOperators, this.valueType)).build();
    }

    private static List<OperatorMethodHandle> getReadValueOperatorMethodHandles(TypeOperators typeOperators, MapType mapType) {
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        MethodHandle keyReadOperator = typeOperators.getReadValueOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT));
        MethodHandle valueReadOperator = typeOperators.getReadValueOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT));
        MethodHandle readFlat = MethodHandles.insertArguments(READ_FLAT, 0, mapType, keyReadOperator, valueReadOperator, keyType.getFlatFixedSize(), valueType.getFlatFixedSize());
        MethodHandle readFlatToBlock = MethodHandles.insertArguments(READ_FLAT_TO_BLOCK, 0, keyReadOperator, valueReadOperator, keyType.getFlatFixedSize(), valueType.getFlatFixedSize());
        MethodHandle keyWriteOperator = typeOperators.getReadValueOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        MethodHandle valueWriteOperator = typeOperators.getReadValueOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        MethodHandle writeFlat = MethodHandles.insertArguments(WRITE_FLAT, 0, mapType.getKeyType(), mapType.getValueType(), keyWriteOperator, valueWriteOperator, keyType.getFlatFixedSize(), valueType.getFlatFixedSize(), keyType.isFlatVariableWidth(), valueType.isFlatVariableWidth());
        return List.of(new OperatorMethodHandle(READ_FLAT_CONVENTION, readFlat), new OperatorMethodHandle(READ_FLAT_TO_BLOCK_CONVENTION, readFlatToBlock), new OperatorMethodHandle(WRITE_FLAT_CONVENTION, writeFlat));
    }

    private static OperatorMethodHandle getHashCodeOperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle keyHashCodeOperator = typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        MethodHandle valueHashCodeOperator = typeOperators.getHashCodeOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(keyHashCodeOperator).bindTo(valueHashCodeOperator));
    }

    private static OperatorMethodHandle getXxHash64OperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle keyHashCodeOperator = typeOperators.getXxHash64Operator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        MethodHandle valueHashCodeOperator = typeOperators.getXxHash64Operator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(keyHashCodeOperator).bindTo(valueHashCodeOperator));
    }

    private static OperatorMethodHandle getEqualOperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle seekKey = MethodHandles.insertArguments(SEEK_KEY, 1, typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)), typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)));
        MethodHandle valueEqualOperator = typeOperators.getEqualOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(seekKey).bindTo(valueEqualOperator));
    }

    private static OperatorMethodHandle getDistinctFromOperatorInvoker(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle seekKey = MethodHandles.insertArguments(SEEK_KEY, 1, typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)), typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL)));
        MethodHandle valueDistinctFromOperator = typeOperators.getDistinctFromOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        MethodHandle methodHandle = DISTINCT_FROM.bindTo(seekKey).bindTo(valueDistinctFromOperator);
        return new OperatorMethodHandle(DISTINCT_FROM_CONVENTION, methodHandle);
    }

    private static OperatorMethodHandle getIndeterminateOperatorInvoker(TypeOperators typeOperators, Type valueType) {
        MethodHandle valueIndeterminateOperator = typeOperators.getIndeterminateOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL));
        return new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(valueIndeterminateOperator));
    }

    @Override
    public MapBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new MapBlockBuilder(this, blockBuilderStatus, expectedEntries);
    }

    @Override
    public MapBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isComparable() {
        return this.valueType.isComparable();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        SqlMap sqlMap = this.getObject(block, position);
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            map.put(this.keyType.getObjectValue(session, rawKeyBlock, rawOffset + i), this.valueType.getObjectValue(session, rawValueBlock, rawOffset + i));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeObject(blockBuilder, this.getObject(block, position));
        }
    }

    @Override
    public SqlMap getObject(Block block, int position) {
        return MapType.read((MapBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        if (!(value instanceof SqlMap)) {
            throw new IllegalArgumentException("Maps must be represented with SqlMap");
        }
        SqlMap sqlMap = (SqlMap)value;
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        ((MapBlockBuilder)blockBuilder).buildEntry((keyBuilder, valueBuilder) -> {
            for (int i = 0; i < sqlMap.getSize(); ++i) {
                this.keyType.appendTo(rawKeyBlock, rawOffset + i, keyBuilder);
                this.valueType.appendTo(rawValueBlock, rawOffset + i, valueBuilder);
            }
        });
    }

    @Override
    public int getFlatFixedSize() {
        return 8;
    }

    @Override
    public boolean isFlatVariableWidth() {
        return true;
    }

    @Override
    public int getFlatVariableWidthSize(Block block, int position) {
        int index;
        SqlMap sqlMap = this.getObject(block, position);
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        long flatSize = (long)sqlMap.getSize() * ((long)(this.keyType.getFlatFixedSize() + this.valueType.getFlatFixedSize()) + 2L);
        if (this.keyType.isFlatVariableWidth()) {
            for (index = 0; index < sqlMap.getSize(); ++index) {
                if (rawKeyBlock.isNull(rawOffset + index)) continue;
                flatSize += (long)this.keyType.getFlatVariableWidthSize(rawKeyBlock, rawOffset + index);
            }
        }
        if (this.valueType.isFlatVariableWidth()) {
            for (index = 0; index < sqlMap.getSize(); ++index) {
                if (rawValueBlock.isNull(rawOffset + index)) continue;
                flatSize += (long)this.valueType.getFlatVariableWidthSize(rawValueBlock, rawOffset + index);
            }
        }
        return Math.toIntExact(flatSize);
    }

    @Override
    public int relocateFlatVariableWidthOffsets(byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4, variableSizeOffset);
        int size = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int keyFixedSize = this.keyType.getFlatFixedSize();
        int valueFixedSize = this.valueType.getFlatFixedSize();
        if (!this.keyType.isFlatVariableWidth() && !this.valueType.isFlatVariableWidth()) {
            return size * (2 + keyFixedSize + valueFixedSize);
        }
        return this.relocateVariableWidthData(size, keyFixedSize, valueFixedSize, variableSizeSlice, variableSizeOffset);
    }

    private int relocateVariableWidthData(int size, int keyFixedSize, int valueFixedSize, byte[] slice, int offset) {
        int writeFixedOffset = offset;
        int writeVariableWidthOffset = offset + size * (2 + keyFixedSize + valueFixedSize);
        for (int index = 0; index < size; ++index) {
            if (!this.keyType.isFlatVariableWidth() || slice[writeFixedOffset] != 0) {
                ++writeFixedOffset;
            } else {
                int keyVariableSize = this.keyType.relocateFlatVariableWidthOffsets(slice, ++writeFixedOffset, slice, writeVariableWidthOffset);
                writeVariableWidthOffset += keyVariableSize;
            }
            if (!this.valueType.isFlatVariableWidth() || slice[writeFixedOffset += keyFixedSize] != 0) {
                ++writeFixedOffset;
            } else {
                int valueVariableSize = this.valueType.relocateFlatVariableWidthOffsets(slice, ++writeFixedOffset, slice, writeVariableWidthOffset);
                writeVariableWidthOffset += valueVariableSize;
            }
            writeFixedOffset += valueFixedSize;
        }
        return writeVariableWidthOffset - offset;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Arrays.asList(this.getKeyType(), this.getValueType());
    }

    @Override
    public String getDisplayName() {
        return "map(" + this.keyType.getDisplayName() + ", " + this.valueType.getDisplayName() + ")";
    }

    public MapBlock createBlockFromKeyValue(Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        return MapBlock.fromKeyValueBlock(mapIsNull, offsets, keyBlock, valueBlock, this);
    }

    public MethodHandle getKeyNativeHashCode() {
        return this.keyNativeHashCode;
    }

    public MethodHandle getKeyBlockHashCode() {
        return this.keyBlockHashCode;
    }

    public MethodHandle getKeyBlockNativeEqual() {
        return this.keyBlockNativeEqual;
    }

    public MethodHandle getKeyBlockEqual() {
        return this.keyBlockEqual;
    }

    public MethodHandle getKeyBlockNativeNotDistinctFrom() {
        return this.keyBlockNativeNotDistinctFrom;
    }

    public MethodHandle getKeyBlockNotDistinctFrom() {
        return this.keyBlockNotDistinctFrom;
    }

    private static long hashOperator(MethodHandle keyOperator, MethodHandle valueOperator, SqlMap sqlMap) throws Throwable {
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        long result = 0L;
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            result += MapType.invokeHashOperator(keyOperator, rawKeyBlock, rawOffset + i) ^ MapType.invokeHashOperator(valueOperator, rawValueBlock, rawOffset + i);
        }
        return result;
    }

    private static long invokeHashOperator(MethodHandle hashOperator, Block block, int position) throws Throwable {
        if (block.isNull(position)) {
            return 0L;
        }
        return hashOperator.invokeExact(block, position);
    }

    private static SqlMap read(MapBlock block, int position) {
        return block.getMap(position);
    }

    private static SqlMap readFlat(MapType mapType, MethodHandle keyReadOperator, MethodHandle valueReadOperator, int keyFixedSize, int valueFixedSize, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableWidthSlice) throws Throwable {
        int size = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int variableWidthOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4);
        return MapValueBuilder.buildMapValue(mapType, size, (keyBuilder, valueBuilder) -> MapType.readFlatEntries(keyReadOperator, valueReadOperator, keyFixedSize, valueFixedSize, size, variableWidthSlice, variableWidthOffset, keyBuilder, valueBuilder));
    }

    private static void readFlatToBlock(MethodHandle keyReadOperator, MethodHandle valueReadOperator, int keyFixedSize, int valueFixedSize, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableWidthSlice, BlockBuilder blockBuilder) throws Throwable {
        int size = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int variableWidthOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4);
        ((MapBlockBuilder)blockBuilder).buildEntry((keyBuilder, valueBuilder) -> MapType.readFlatEntries(keyReadOperator, valueReadOperator, keyFixedSize, valueFixedSize, size, variableWidthSlice, variableWidthOffset, keyBuilder, valueBuilder));
    }

    private static void readFlatEntries(MethodHandle keyReadFlat, MethodHandle valueReadFlat, int keyFixedSize, int valueFixedSize, int size, byte[] slice, int offset, BlockBuilder keyBuilder, BlockBuilder valueBuilder) throws Throwable {
        for (int index = 0; index < size; ++index) {
            boolean keyIsNull = slice[offset] != 0;
            ++offset;
            if (keyIsNull) {
                keyBuilder.appendNull();
            } else {
                keyReadFlat.invokeExact(slice, offset, slice, keyBuilder);
            }
            boolean valueIsNull = slice[offset += keyFixedSize] != 0;
            ++offset;
            if (valueIsNull) {
                valueBuilder.appendNull();
            } else {
                valueReadFlat.invokeExact(slice, offset, slice, valueBuilder);
            }
            offset += valueFixedSize;
        }
    }

    private static void writeFlat(Type keyType, Type valueType, MethodHandle keyWriteFlat, MethodHandle valueWriteFlat, int keyFixedSize, int valueFixedSize, boolean keyVariableWidth, boolean valueVariableWidth, SqlMap map, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) throws Throwable {
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, map.getSize());
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4, variableSizeOffset);
        MapType.writeFlatEntries(keyType, valueType, keyWriteFlat, valueWriteFlat, keyFixedSize, valueFixedSize, keyVariableWidth, valueVariableWidth, map, variableSizeSlice, variableSizeOffset);
    }

    private static void writeFlatEntries(Type keyType, Type valueType, MethodHandle keyWriteFlat, MethodHandle valueWriteFlat, int keyFixedSize, int valueFixedSize, boolean keyVariableWidth, boolean valueVariableWidth, SqlMap sqlMap, byte[] slice, int offset) throws Throwable {
        int size = sqlMap.getSize();
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        int writeVariableWidthOffset = offset + size * (2 + keyFixedSize + valueFixedSize);
        for (int index = 0; index < size; ++index) {
            if (rawKeyBlock.isNull(rawOffset + index)) {
                slice[offset] = 1;
                ++offset;
            } else {
                ++offset;
                int keyVariableSize = 0;
                if (keyVariableWidth) {
                    keyVariableSize = keyType.getFlatVariableWidthSize(rawKeyBlock, rawOffset + index);
                }
                keyWriteFlat.invokeExact(rawKeyBlock, rawOffset + index, slice, offset, slice, writeVariableWidthOffset);
                writeVariableWidthOffset += keyVariableSize;
            }
            offset += keyFixedSize;
            if (rawValueBlock.isNull(rawOffset + index)) {
                slice[offset] = 1;
                ++offset;
            } else {
                ++offset;
                int valueVariableSize = 0;
                if (valueVariableWidth) {
                    valueVariableSize = valueType.getFlatVariableWidthSize(rawValueBlock, rawOffset + index);
                }
                valueWriteFlat.invokeExact(rawValueBlock, rawOffset + index, slice, offset, slice, writeVariableWidthOffset);
                writeVariableWidthOffset += valueVariableSize;
            }
            offset += valueFixedSize;
        }
    }

    private static Boolean equalOperator(MethodHandle seekKey, MethodHandle valueEqualOperator, SqlMap leftMap, SqlMap rightMap) throws Throwable {
        if (leftMap.getSize() != rightMap.getSize()) {
            return false;
        }
        int leftRawOffset = leftMap.getRawOffset();
        Block leftRawKeyBlock = leftMap.getRawKeyBlock();
        Block leftRawValueBlock = leftMap.getRawValueBlock();
        int rightRawOffset = rightMap.getRawOffset();
        Block rightRawValueBlock = rightMap.getRawValueBlock();
        boolean unknown = false;
        for (int leftIndex = 0; leftIndex < leftMap.getSize(); ++leftIndex) {
            int rightIndex = seekKey.invokeExact(rightMap, leftRawKeyBlock, leftRawOffset + leftIndex);
            if (rightIndex == -1) {
                return false;
            }
            if (leftRawValueBlock.isNull(leftRawOffset + leftIndex) || rightRawValueBlock.isNull(rightRawOffset + rightIndex)) {
                unknown = true;
                continue;
            }
            Boolean result = valueEqualOperator.invokeExact(leftRawValueBlock, leftRawOffset + leftIndex, rightRawValueBlock, rightRawOffset + rightIndex);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static boolean distinctFromOperator(MethodHandle seekKey, MethodHandle valueDistinctFromOperator, SqlMap leftMap, SqlMap rightMap) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftMap == null;
        boolean bl = rightIsNull = rightMap == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        if (leftMap.getSize() != rightMap.getSize()) {
            return true;
        }
        int leftRawOffset = leftMap.getRawOffset();
        Block leftRawKeyBlock = leftMap.getRawKeyBlock();
        Block leftRawValueBlock = leftMap.getRawValueBlock();
        int rightRawOffset = rightMap.getRawOffset();
        Block rightRawValueBlock = rightMap.getRawValueBlock();
        for (int leftIndex = 0; leftIndex < leftMap.getSize(); ++leftIndex) {
            int rightIndex = seekKey.invokeExact(rightMap, leftRawKeyBlock, leftRawOffset + leftIndex);
            if (rightIndex == -1) {
                return true;
            }
            boolean result = valueDistinctFromOperator.invokeExact(leftRawValueBlock, leftRawOffset + leftIndex, rightRawValueBlock, rightRawOffset + rightIndex);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static boolean indeterminate(MethodHandle valueIndeterminateFunction, SqlMap sqlMap, boolean isNull) throws Throwable {
        if (isNull) {
            return true;
        }
        int rawOffset = sqlMap.getRawOffset();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            if (rawValueBlock.isNull(rawOffset + i)) {
                return true;
            }
            if (!valueIndeterminateFunction.invokeExact(rawValueBlock, rawOffset + i)) continue;
            return true;
        }
        return false;
    }

    private static boolean not(boolean value) {
        return !value;
    }

    static {
        READ_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.FLAT);
        READ_FLAT_TO_BLOCK_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT);
        WRITE_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        DISTINCT_FROM_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
        INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            NOT = lookup.findStatic(MapType.class, "not", MethodType.methodType(Boolean.TYPE, Boolean.TYPE));
            READ_FLAT = lookup.findStatic(MapType.class, "readFlat", MethodType.methodType(SqlMap.class, MapType.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class));
            READ_FLAT_TO_BLOCK = lookup.findStatic(MapType.class, "readFlatToBlock", MethodType.methodType(Void.TYPE, MethodHandle.class, MethodHandle.class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class, BlockBuilder.class));
            WRITE_FLAT = lookup.findStatic(MapType.class, "writeFlat", MethodType.methodType(Void.TYPE, Type.class, Type.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, SqlMap.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE));
            EQUAL = lookup.findStatic(MapType.class, "equalOperator", MethodType.methodType(Boolean.class, MethodHandle.class, MethodHandle.class, SqlMap.class, SqlMap.class));
            HASH_CODE = lookup.findStatic(MapType.class, "hashOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, MethodHandle.class, SqlMap.class));
            DISTINCT_FROM = lookup.findStatic(MapType.class, "distinctFromOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, MethodHandle.class, SqlMap.class, SqlMap.class));
            INDETERMINATE = lookup.findStatic(MapType.class, "indeterminate", MethodType.methodType(Boolean.TYPE, MethodHandle.class, SqlMap.class, Boolean.TYPE));
            SEEK_KEY = lookup.findVirtual(SqlMap.class, "seekKey", MethodType.methodType(Integer.TYPE, MethodHandle.class, MethodHandle.class, Block.class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

