/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import io.trino.spi.HostAddress;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHostAddress {
    @Test
    public void testEquality() {
        HostAddress address1 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1234);
        HostAddress address1NoBrackets = HostAddress.fromParts((String)"1111:2222:3333:4444:5555:6666:7777:8888", (int)1234);
        Assertions.assertThat((Object)address1).isEqualTo((Object)address1NoBrackets);
        HostAddress address1FromString = HostAddress.fromString((String)"[1111:2222:3333:4444:5555:6666:7777:8888]:1234");
        Assertions.assertThat((Object)address1).isEqualTo((Object)address1FromString);
        HostAddress address2 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:9999]", (int)1234);
        Assertions.assertThat((Object)address1).isNotEqualTo((Object)address2);
        HostAddress address3 = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1235);
        Assertions.assertThat((Object)address1).isNotEqualTo((Object)address3);
    }

    @Test
    public void testRoundTrip() {
        HostAddress address = HostAddress.fromParts((String)"[1111:2222:3333:4444:5555:6666:7777:8888]", (int)1234);
        HostAddress fromParts = HostAddress.fromParts((String)address.getHostText(), (int)address.getPort());
        Assertions.assertThat((Object)address).isEqualTo((Object)fromParts);
        HostAddress fromString = HostAddress.fromString((String)address.toString());
        Assertions.assertThat((Object)address).isEqualTo((Object)fromString);
        Assertions.assertThat((Object)fromParts).isEqualTo((Object)fromString);
    }
}

