/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import io.trino.spi.StandardErrorCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStandardErrorCode {
    private static final int EXTERNAL_ERROR_START = 0x1000000;

    @Test
    public void testUnique() {
        HashSet<Integer> codes = new HashSet<Integer>();
        for (StandardErrorCode code : StandardErrorCode.values()) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)codes.add(TestStandardErrorCode.code(code))).describedAs("Code already exists: " + String.valueOf(code), new Object[0])).isTrue();
        }
        Assertions.assertThat(codes).hasSize(StandardErrorCode.values().length);
    }

    @Test
    public void testReserved() {
        for (StandardErrorCode errorCode : StandardErrorCode.values()) {
            io.airlift.testing.Assertions.assertLessThan((Comparable)Integer.valueOf(TestStandardErrorCode.code(errorCode)), (Comparable)Integer.valueOf(0x1000000));
        }
    }

    @Test
    public void testOrdering() {
        Iterator<StandardErrorCode> iterator = Arrays.asList(StandardErrorCode.values()).iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        int previous = TestStandardErrorCode.code(iterator.next());
        while (iterator.hasNext()) {
            StandardErrorCode code = iterator.next();
            int current = TestStandardErrorCode.code(code);
            io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(current), (Comparable)Integer.valueOf(previous), (String)("Code is out of order: " + String.valueOf(code)));
            if (code != StandardErrorCode.GENERIC_INTERNAL_ERROR && code != StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES && code != StandardErrorCode.UNSUPPORTED_TABLE_TYPE) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)current).describedAs("Code is not sequential: " + String.valueOf(code), new Object[0])).isEqualTo(previous + 1);
            }
            previous = current;
        }
    }

    private static int code(StandardErrorCode error) {
        return error.toErrorCode().getCode();
    }
}

