/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestArrayBlockBuilder
extends AbstractTestBlockBuilder<List<String>> {
    private static final int THREE_INTS_ENTRY_SIZE = 32;
    private static final int EXPECTED_ENTRY_COUNT = 100;

    @Test
    public void testArrayBlockIsFull() {
        this.testIsFull(new PageBuilderStatus(3200));
    }

    private void testIsFull(PageBuilderStatus pageBuilderStatus) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, pageBuilderStatus.createBlockBuilderStatus(), 100);
        Assertions.assertThat((boolean)pageBuilderStatus.isEmpty()).isTrue();
        while (!pageBuilderStatus.isFull()) {
            blockBuilder.buildEntry(elementBuilder -> {
                BigintType.BIGINT.writeLong(elementBuilder, 12L);
                elementBuilder.appendNull();
                BigintType.BIGINT.writeLong(elementBuilder, 34L);
            });
        }
        Assertions.assertThat((int)blockBuilder.getPositionCount()).isEqualTo(100);
        Assertions.assertThat((boolean)pageBuilderStatus.isFull()).isEqualTo(true);
    }

    @Test
    public void testRetainedSizeInBytes() {
        int expectedEntries = 1000;
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, expectedEntries);
        long initialRetainedSize = arrayBlockBuilder.getRetainedSizeInBytes();
        int i = 0;
        while (i < expectedEntries) {
            int value = i++;
            arrayBlockBuilder.buildEntry(elementBuilder -> BigintType.BIGINT.writeLong(elementBuilder, (long)value));
        }
        Assertions.assertThat((long)arrayBlockBuilder.getRetainedSizeInBytes()).isGreaterThanOrEqualTo((long)(expectedEntries * 8 + SizeOf.instanceSize(LongArrayBlockBuilder.class)) + initialRetainedSize);
    }

    @Test
    public void testConcurrentWriting() {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100);
        blockBuilder.buildEntry(elementBuilder -> {
            BigintType.BIGINT.writeLong(elementBuilder, 45L);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> blockBuilder.buildEntry(ignore -> {})).isInstanceOf(IllegalStateException.class)).hasMessage("Expected current entry to be closed but was opened");
        });
    }

    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().build(), 0);
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestArrayBlockBuilder.assertIsAllNulls(TestArrayBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
    }

    private static BlockBuilder blockBuilder() {
        return new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 10);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(ArrayBlock.class);
        } else {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(RunLengthEncodedBlock.class);
            Assertions.assertThat((Class)((RunLengthEncodedBlock)block).getValue().getClass()).isEqualTo(ArrayBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assertions.assertThat((boolean)block.isNull(0)).isTrue();
        }
    }

    @Override
    protected BlockBuilder createBlockBuilder() {
        return new ArrayBlockBuilder((BlockBuilder)new VariableWidthBlockBuilder(null, 1, 100), null, 1);
    }

    @Override
    protected List<List<String>> getTestValues() {
        return List.of(List.of("a", "apple", "ape"), Arrays.asList("b", null, "bear", "break"), List.of("c", "cherry"), Arrays.asList("d", "date", "dinosaur", null, "dirt"), List.of("e", "eggplant", "empty", ""));
    }

    @Override
    protected List<String> getUnusedTestValue() {
        return List.of("unused", "ignore me");
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<List<String>> values) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((BlockBuilder)new VariableWidthBlockBuilder(null, 1, 100), null, 1);
        for (List<String> array : values) {
            if (array == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(elementBuilder -> {
                for (String entry : array) {
                    if (entry == null) {
                        elementBuilder.appendNull();
                        continue;
                    }
                    VarcharType.VARCHAR.writeString(elementBuilder, entry);
                }
            });
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<List<String>> blockToValues(ValueBlock valueBlock) {
        ArrayBlock block = (ArrayBlock)valueBlock;
        ArrayList<List<String>> actualValues = new ArrayList<List<String>>(block.getPositionCount());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            Block array = block.getArray(i);
            ArrayList<String> arrayBuilder = new ArrayList<String>();
            for (int j = 0; j < array.getPositionCount(); ++j) {
                if (array.isNull(j)) {
                    arrayBuilder.add(null);
                    continue;
                }
                arrayBuilder.add(VarcharType.VARCHAR.getSlice(array, j).toStringUtf8());
            }
            actualValues.add(arrayBuilder);
        }
        return actualValues;
    }
}

