/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.BlockTestUtils;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDictionaryBlockEncoding {
    private final BlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
    private final Block dictionary = TestDictionaryBlockEncoding.buildTestDictionary();

    @Test
    public void testRoundTrip() {
        int positionCount = 40;
        int[] ids = new int[positionCount];
        for (int i = 0; i < 40; ++i) {
            ids[i] = i % 4;
        }
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, (Block)dictionaryBlock);
    }

    @Test
    public void testNonSequentialDictionaryUnnest() {
        int[] ids = new int[]{3, 2, 1, 0};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 4));
    }

    @Test
    public void testNonSequentialDictionaryUnnestWithGaps() {
        int[] ids = new int[]{3, 2, 0};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assertions.assertThat((Object)actualBlock).isInstanceOf(VariableWidthBlock.class);
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 3));
    }

    @Test
    public void testSequentialDictionaryUnnest() {
        int[] ids = new int[]{0, 1, 2, 3};
        DictionaryBlock dictionaryBlock = (DictionaryBlock)DictionaryBlock.create((int)ids.length, (Block)this.dictionary, (int[])ids);
        Block actualBlock = this.roundTripBlock((Block)dictionaryBlock);
        Assertions.assertThat((Object)actualBlock).isInstanceOf(VariableWidthBlock.class);
        BlockTestUtils.assertBlockEquals((Type)VarcharType.VARCHAR, actualBlock, this.dictionary.getPositions(ids, 0, 4));
    }

    private Block roundTripBlock(Block block) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, block);
        return this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
    }

    private static Block buildTestDictionary() {
        VariableWidthBlockBuilder dictionaryBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 4);
        VarcharType.VARCHAR.writeString((BlockBuilder)dictionaryBuilder, "alice");
        VarcharType.VARCHAR.writeString((BlockBuilder)dictionaryBuilder, "bob");
        VarcharType.VARCHAR.writeString((BlockBuilder)dictionaryBuilder, "charlie");
        VarcharType.VARCHAR.writeString((BlockBuilder)dictionaryBuilder, "dave");
        return dictionaryBuilder.build();
    }
}

