/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.Int128ArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Int128;
import java.util.ArrayList;
import java.util.List;

public class TestInt128ArrayBlockBuilder
extends AbstractTestBlockBuilder<Int128> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new Int128ArrayBlockBuilder(null, 1);
    }

    @Override
    protected List<Int128> getTestValues() {
        return List.of(Int128.valueOf((long)90L, (long)10L), Int128.valueOf((long)91L, (long)11L), Int128.valueOf((long)92L, (long)12L), Int128.valueOf((long)93L, (long)13L), Int128.valueOf((long)94L, (long)14L));
    }

    @Override
    protected Int128 getUnusedTestValue() {
        return Int128.valueOf((long)-1L, (long)-2L);
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Int128> values) {
        Int128ArrayBlockBuilder blockBuilder = new Int128ArrayBlockBuilder(null, 1);
        for (Int128 value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeInt128(value.getHigh(), value.getLow());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Int128> blockToValues(ValueBlock valueBlock) {
        Int128ArrayBlock int128ArrayBlock = (Int128ArrayBlock)valueBlock;
        ArrayList<Int128> actualValues = new ArrayList<Int128>(int128ArrayBlock.getPositionCount());
        for (int i = 0; i < int128ArrayBlock.getPositionCount(); ++i) {
            if (int128ArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(int128ArrayBlock.getInt128(i));
        }
        return actualValues;
    }
}

