/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RowBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLazyBlock {
    @Test
    public void testListener() {
        ArrayList notifications = new ArrayList();
        LazyBlock lazyBlock = new LazyBlock(1, () -> TestLazyBlock.createSingleValueBlock(1));
        LazyBlock.listenForLoads((Block)lazyBlock, notifications::add);
        Block loadedBlock = lazyBlock.getBlock();
        Assertions.assertThat(notifications).isEqualTo((Object)ImmutableList.of((Object)loadedBlock));
        loadedBlock = lazyBlock.getBlock();
        Assertions.assertThat(notifications).isEqualTo((Object)ImmutableList.of((Object)loadedBlock));
    }

    @Test
    public void testNestedListener() {
        ArrayList<Block> actualNotifications = new ArrayList<Block>();
        LazyBlock lazyBlock = new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock);
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        ArrayList<Block> expectedNotifications = new ArrayList<Block>();
        TestLazyBlock.assertNotificationsRecursive(5, (Block)lazyBlock, actualNotifications, expectedNotifications);
    }

    @Test
    public void testLoadedBlockNestedListener() {
        ArrayList actualNotifications = new ArrayList();
        LazyBlock lazyBlock = new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock);
        RowBlock nestedRowBlock = (RowBlock)lazyBlock.getBlock();
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        Block loadedBlock = ((LazyBlock)nestedRowBlock.getFieldBlock(0)).getBlock();
        Assertions.assertThat(actualNotifications).isEqualTo((Object)ImmutableList.of((Object)loadedBlock));
    }

    @Test
    public void testNestedGetLoadedBlock() {
        ArrayList actualNotifications = new ArrayList();
        IntArrayBlock arrayBlock = new IntArrayBlock(2, Optional.empty(), new int[]{0, 1});
        LazyBlock lazyArrayBlock = new LazyBlock(2, () -> TestLazyBlock.lambda$testNestedGetLoadedBlock$1((Block)arrayBlock));
        RowBlock rowBlock = RowBlock.fromFieldBlocks((int)2, (Block[])new Block[]{lazyArrayBlock});
        LazyBlock lazyBlock = new LazyBlock(2, () -> TestLazyBlock.lambda$testNestedGetLoadedBlock$2((Block)rowBlock));
        LazyBlock.listenForLoads((Block)lazyBlock, actualNotifications::add);
        Block loadedBlock = lazyBlock.getBlock();
        Assertions.assertThat((Object)loadedBlock).isInstanceOf(RowBlock.class);
        Assertions.assertThat((Object)((RowBlock)loadedBlock).getFieldBlock(0)).isInstanceOf(LazyBlock.class);
        Assertions.assertThat(actualNotifications).isEqualTo((Object)ImmutableList.of((Object)loadedBlock));
        Block fullyLoadedBlock = lazyBlock.getLoadedBlock();
        Assertions.assertThat((Object)fullyLoadedBlock).isInstanceOf(RowBlock.class);
        Assertions.assertThat((Object)((RowBlock)fullyLoadedBlock).getFieldBlock(0)).isInstanceOf(IntArrayBlock.class);
        Assertions.assertThat(actualNotifications).isEqualTo((Object)ImmutableList.of((Object)loadedBlock, (Object)arrayBlock));
        Assertions.assertThat((boolean)lazyBlock.isLoaded()).isTrue();
        Assertions.assertThat((boolean)rowBlock.isLoaded()).isTrue();
    }

    private static void assertNotificationsRecursive(int depth, Block lazyBlock, List<Block> actualNotifications, List<Block> expectedNotifications) {
        Assertions.assertThat((boolean)lazyBlock.isLoaded()).isFalse();
        Block loadedBlock = ((LazyBlock)lazyBlock).getBlock();
        expectedNotifications.add(loadedBlock);
        Assertions.assertThat(actualNotifications).isEqualTo(expectedNotifications);
        if (loadedBlock instanceof ArrayBlock) {
            ArrayBlock arrayBlock = (ArrayBlock)loadedBlock;
            long expectedSize = 5L * (long)loadedBlock.getPositionCount();
            Assertions.assertThat((long)loadedBlock.getSizeInBytes()).isEqualTo(expectedSize);
            Block elementsBlock = arrayBlock.getRawElementBlock();
            if (depth > 0) {
                TestLazyBlock.assertNotificationsRecursive(depth - 1, elementsBlock, actualNotifications, expectedNotifications);
            }
            Assertions.assertThat((long)loadedBlock.getSizeInBytes()).isEqualTo(expectedSize += elementsBlock.getSizeInBytes());
            return;
        }
        if (loadedBlock instanceof RowBlock) {
            RowBlock rowBlock = (RowBlock)loadedBlock;
            long expectedSizeInBytes = loadedBlock.getPositionCount();
            Assertions.assertThat((long)loadedBlock.getSizeInBytes()).isEqualTo(expectedSizeInBytes);
            for (Block fieldBlock : rowBlock.getFieldBlocks()) {
                if (depth > 0) {
                    TestLazyBlock.assertNotificationsRecursive(depth - 1, fieldBlock, actualNotifications, expectedNotifications);
                }
                long fieldBlockSize = fieldBlock.getSizeInBytes();
                Assertions.assertThat((long)loadedBlock.getSizeInBytes()).isEqualTo(expectedSizeInBytes += fieldBlockSize);
            }
            return;
        }
        throw new IllegalArgumentException("Unexpected loaded block type: " + loadedBlock.getClass().getSimpleName());
    }

    private static Block createSingleValueBlock(int value) {
        return new IntArrayBlock(1, Optional.empty(), new int[]{value});
    }

    private static Block createInfiniteRecursiveRowBlock() {
        return RowBlock.fromFieldBlocks((int)1, (Block[])new Block[]{new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock), new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveArrayBlock)});
    }

    private static Block createInfiniteRecursiveArrayBlock() {
        return ArrayBlock.fromElementBlock((int)1, Optional.empty(), (int[])new int[]{0, 1}, (Block)new LazyBlock(1, TestLazyBlock::createInfiniteRecursiveRowBlock));
    }

    private static /* synthetic */ Block lambda$testNestedGetLoadedBlock$2(Block rowBlock) {
        return rowBlock;
    }

    private static /* synthetic */ Block lambda$testNestedGetLoadedBlock$1(Block arrayBlock) {
        return arrayBlock;
    }
}

