/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.List;

public class TestLongArrayBlockBuilder
extends AbstractTestBlockBuilder<Long> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new LongArrayBlockBuilder(null, 1);
    }

    @Override
    protected List<Long> getTestValues() {
        return List.of(Long.valueOf(10L), Long.valueOf(11L), Long.valueOf(12L), Long.valueOf(13L), Long.valueOf(14L));
    }

    @Override
    protected Long getUnusedTestValue() {
        return -1L;
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Long> values) {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, 1);
        for (Long value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeLong(value.longValue());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Long> blockToValues(ValueBlock valueBlock) {
        LongArrayBlock longArrayBlock = (LongArrayBlock)valueBlock;
        ArrayList<Long> actualValues = new ArrayList<Long>(longArrayBlock.getPositionCount());
        for (int i = 0; i < longArrayBlock.getPositionCount(); ++i) {
            if (longArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(longArrayBlock.getLong(i));
        }
        return actualValues;
    }
}

