/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestMapBlockBuilder
extends AbstractTestBlockBuilder<Map<String, Integer>> {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final MapType MAP_TYPE = new MapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER, TYPE_OPERATORS);

    @Override
    protected BlockBuilder createBlockBuilder() {
        return new MapBlockBuilder(MAP_TYPE, null, 1);
    }

    @Override
    protected List<Map<String, Integer>> getTestValues() {
        return List.of(Map.of("a", 0, "apple", 1, "ape", 2), Map.of("b", 3, "banana", 4, "bear", 5, "break", 6), Map.of("c", 7, "cherry", 8), Map.of("d", 9, "date", 10, "dinosaur", 11, "dinner", 12, "dirt", 13), Map.of("e", 14, "eggplant", 15, "empty", 16, "", 17));
    }

    @Override
    protected Map<String, Integer> getUnusedTestValue() {
        return Map.of("unused", -1, "ignore me", -2);
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Map<String, Integer>> maps) {
        MapBlockBuilder blockBuilder = new MapBlockBuilder(MAP_TYPE, null, 1);
        for (Map<String, Integer> map : maps) {
            if (map == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : map.entrySet()) {
                    VarcharType.VARCHAR.writeString(keyBuilder, (String)entry.getKey());
                    IntegerType.INTEGER.writeLong(valueBuilder, (long)((Integer)entry.getValue()).intValue());
                }
            });
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Map<String, Integer>> blockToValues(ValueBlock valueBlock) {
        MapBlock block = (MapBlock)valueBlock;
        ArrayList<Map<String, Integer>> actualValues = new ArrayList<Map<String, Integer>>(block.getPositionCount());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            SqlMap sqlMap = block.getMap(i);
            int rawOffset = sqlMap.getRawOffset();
            Block rawKeyBlock = sqlMap.getRawKeyBlock();
            Block rawValueBlock = sqlMap.getRawValueBlock();
            HashMap<String, Integer> actualMap = new HashMap<String, Integer>();
            for (int entryIndex = 0; entryIndex < sqlMap.getSize(); ++entryIndex) {
                actualMap.put(VarcharType.VARCHAR.getSlice(rawKeyBlock, rawOffset + entryIndex).toStringUtf8(), IntegerType.INTEGER.getInt(rawValueBlock, rawOffset + entryIndex));
            }
            actualValues.add(actualMap);
        }
        return actualValues;
    }
}

