/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.ArrayBlockEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.ByteArrayBlockEncoding;
import io.trino.spi.block.DictionaryBlockEncoding;
import io.trino.spi.block.Fixed12BlockEncoding;
import io.trino.spi.block.Int128ArrayBlockEncoding;
import io.trino.spi.block.IntArrayBlockEncoding;
import io.trino.spi.block.LazyBlockEncoding;
import io.trino.spi.block.LongArrayBlockEncoding;
import io.trino.spi.block.MapBlockEncoding;
import io.trino.spi.block.RowBlockEncoding;
import io.trino.spi.block.RunLengthBlockEncoding;
import io.trino.spi.block.ShortArrayBlockEncoding;
import io.trino.spi.block.VariableWidthBlockEncoding;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public final class TestingBlockEncodingSerde
implements BlockEncodingSerde {
    private final Function<TypeId, Type> types;
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();

    public TestingBlockEncodingSerde() {
        this(new TestingTypeManager()::getType);
    }

    public TestingBlockEncodingSerde(Function<TypeId, Type> types) {
        this.types = Objects.requireNonNull(types, "types is null");
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Fixed12BlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new MapBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
    }

    private void addBlockEncoding(BlockEncoding blockEncoding) {
        this.blockEncodings.put(blockEncoding.getName(), blockEncoding);
    }

    public Block readBlock(SliceInput input) {
        String encodingName = TestingBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding %s", (Object)encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        TestingBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    public Type readType(SliceInput sliceInput) {
        Objects.requireNonNull(sliceInput, "sliceInput is null");
        String id = TestingBlockEncodingSerde.readLengthPrefixedString(sliceInput);
        Type type = this.types.apply(TypeId.of((String)id));
        if (type == null) {
            throw new IllegalArgumentException("Unknown type " + id);
        }
        return type;
    }

    public void writeType(SliceOutput sliceOutput, Type type) {
        Objects.requireNonNull(sliceOutput, "sliceOutput is null");
        Objects.requireNonNull(type, "type is null");
        TestingBlockEncodingSerde.writeLengthPrefixedString(sliceOutput, type.getTypeId().getId());
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

