/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import io.airlift.json.JsonCodec;
import io.trino.spi.eventlistener.ColumnMaskReferenceInfo;
import io.trino.spi.eventlistener.MaterializedViewReferenceInfo;
import io.trino.spi.eventlistener.RowFilterReferenceInfo;
import io.trino.spi.eventlistener.TableReferenceInfo;
import io.trino.spi.eventlistener.ViewReferenceInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableReferenceInfo {
    private final JsonCodec<TableReferenceInfo> codec = JsonCodec.jsonCodec(TableReferenceInfo.class);

    @Test
    public void testJsonRoundTrip() {
        this.assertRoundTrip((TableReferenceInfo)new ViewReferenceInfo("catalogName", "schemaName", "viewName"));
        this.assertRoundTrip((TableReferenceInfo)new MaterializedViewReferenceInfo("catalogName", "schemaName", "materializedViewName"));
        this.assertRoundTrip((TableReferenceInfo)new RowFilterReferenceInfo("expression", "targetCatalogName", "targetSchemaName", "targetTableName"));
        this.assertRoundTrip((TableReferenceInfo)new ColumnMaskReferenceInfo("expression", "targetCatalogName", "targetSchemaName", "targetTableName", "targetColumnName"));
    }

    private void assertRoundTrip(TableReferenceInfo info) {
        Assertions.assertThat((Object)((TableReferenceInfo)this.codec.fromJson(this.codec.toJson((Object)info)))).isEqualTo((Object)info);
    }
}

