/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.trino.jmh.Benchmarks;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.LongStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkSortedRangeSet {
    @Benchmark
    public SortedRangeSet benchmarkBuilder(Data data) {
        return SortedRangeSet.buildFromUnsortedRanges((Type)BigintType.BIGINT, data.ranges);
    }

    @Benchmark
    public List<SortedRangeSet> ofSingleRange(Data data) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(data.ranges.size());
        for (Range range : data.ranges) {
            ValueSet valueSet = ValueSet.ofRanges((Range)range, (Range[])new Range[0]);
            result.add((SortedRangeSet)valueSet);
        }
        return result;
    }

    @Benchmark
    public List<Boolean> equalsSmall(Data data) {
        return this.benchmarkEquals(data.smallRanges);
    }

    @Benchmark
    public List<Boolean> equalsLarge(Data data) {
        return this.benchmarkEquals(data.largeRanges);
    }

    private List<Boolean> benchmarkEquals(List<SortedRangeSet> dataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).equals((Object)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<SortedRangeSet> unionSmall(Data data) {
        return this.benchmarkUnion(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> unionLarge(Data data) {
        return this.benchmarkUnion(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkUnion(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).union((ValueSet)dataRanges.get(index + 1)));
        }
        return result;
    }

    @Benchmark
    public List<Boolean> overlapsSmall(Data data) {
        return this.benchmarkOverlaps(data.smallRanges, data.smallRanges);
    }

    @Benchmark
    public List<Boolean> overlapsLarge(Data data) {
        return this.benchmarkOverlaps(data.largeRanges, data.largeRanges);
    }

    @Benchmark
    public List<Boolean> overlapsSmallOnVeryLarge(Data data) {
        return this.benchmarkOverlaps(data.veryLargeRanges, data.smallRanges);
    }

    private List<Boolean> benchmarkOverlaps(List<SortedRangeSet> dataRanges, List<SortedRangeSet> otherDataRanges) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add(dataRanges.get(index).overlaps((ValueSet)otherDataRanges.get(index + 1 % otherDataRanges.size())));
        }
        return result;
    }

    @Benchmark
    public List<ValueSet> linearIntersectSmall(Data data) {
        return this.benchmarkIntersect(data.smallRanges, data.smallRanges, SortedRangeSet::linearSearchIntersect);
    }

    @Benchmark
    public List<ValueSet> binaryIntersectSmall(Data data) {
        return this.benchmarkIntersect(data.smallRanges, data.smallRanges, SortedRangeSet::binarySearchIntersect);
    }

    @Benchmark
    public List<ValueSet> linearIntersectLarge(Data data) {
        return this.benchmarkIntersect(data.largeRanges, data.largeRanges, SortedRangeSet::linearSearchIntersect);
    }

    @Benchmark
    public List<ValueSet> binaryIntersectLarge(Data data) {
        return this.benchmarkIntersect(data.largeRanges, data.largeRanges, SortedRangeSet::binarySearchIntersect);
    }

    @Benchmark
    public List<ValueSet> linearIntersectSmallOnVeryLarge(Data data) {
        return this.benchmarkIntersect(data.largeRanges, data.smallRanges, SortedRangeSet::linearSearchIntersect);
    }

    @Benchmark
    public List<ValueSet> binaryIntersectSmallOnVeryLarge(Data data) {
        return this.benchmarkIntersect(data.largeRanges, data.smallRanges, SortedRangeSet::binarySearchIntersect);
    }

    @Benchmark
    public List<ValueSet> linearIntersectDiscreteOnLarge(Data data) {
        return this.benchmarkIntersectionSingle(data.largeDiscreteSortedRangeSet, SortedRangeSet::linearSearchIntersect);
    }

    @Benchmark
    public List<ValueSet> binaryIntersectRangeOnLarge(Data data) {
        return this.benchmarkIntersectionSingle(data.largeRangeSortedRangeSet, SortedRangeSet::binarySearchIntersect);
    }

    @Benchmark
    public List<ValueSet> linearIntersectRangeOnLarge(Data data) {
        return this.benchmarkIntersectionSingle(data.largeRangeSortedRangeSet, SortedRangeSet::linearSearchIntersect);
    }

    @Benchmark
    public List<ValueSet> binaryIntersectDiscreteOnLarge(Data data) {
        return this.benchmarkIntersectionSingle(data.largeDiscreteSortedRangeSet, SortedRangeSet::binarySearchIntersect);
    }

    public List<ValueSet> benchmarkIntersectionSingle(SortedRangeSet target, BiFunction<SortedRangeSet, SortedRangeSet, SortedRangeSet> intersection) {
        ArrayList<ValueSet> result = new ArrayList<ValueSet>(10);
        for (int i = 0; i < 10; ++i) {
            SortedRangeSet test = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)ThreadLocalRandom.current().nextLong(0L, 100L), (i % 2 == 0 ? 1 : 0) != 0, (Object)ThreadLocalRandom.current().nextLong(99950L, 100000L), (i % 2 == 1 ? 1 : 0) != 0), (Range[])new Range[0]);
            result.add((ValueSet)intersection.apply(target, test));
        }
        return result;
    }

    private List<ValueSet> benchmarkIntersect(List<SortedRangeSet> dataRanges, List<SortedRangeSet> testRanges, BiFunction<SortedRangeSet, SortedRangeSet, SortedRangeSet> intersection) {
        ArrayList<ValueSet> result = new ArrayList<ValueSet>(dataRanges.size() - 1);
        for (int index = 0; index < dataRanges.size() - 1; ++index) {
            result.add((ValueSet)intersection.apply(dataRanges.get(index), testRanges.get(index + 1 % testRanges.size())));
        }
        return result;
    }

    @Benchmark
    public long containsValueSmall(Data data) {
        return this.benchmarkContainsValue(data.smallRanges);
    }

    @Benchmark
    public long containsValueLarge(Data data) {
        return this.benchmarkContainsValue(data.largeRanges);
    }

    private long benchmarkContainsValue(List<SortedRangeSet> dataRanges) {
        int totalChecks = 5000000;
        long testedValuesTo = 10000L;
        long checksPerSet = totalChecks / dataRanges.size();
        long step = testedValuesTo / checksPerSet;
        long found = 0L;
        for (SortedRangeSet dataRange : dataRanges) {
            for (long i = 0L; i < testedValuesTo; i += step) {
                boolean contained = dataRange.containsValue((Object)i);
                if (!contained) continue;
                ++found;
            }
        }
        return found;
    }

    @Benchmark
    public List<SortedRangeSet> complementSmall(Data data) {
        return this.benchmarkComplement(data.smallRanges);
    }

    @Benchmark
    public List<SortedRangeSet> complementLarge(Data data) {
        return this.benchmarkComplement(data.largeRanges);
    }

    private List<SortedRangeSet> benchmarkComplement(List<SortedRangeSet> dataRanges) {
        ArrayList<SortedRangeSet> result = new ArrayList<SortedRangeSet>(dataRanges.size());
        for (SortedRangeSet dataRange : dataRanges) {
            result.add(dataRange.complement());
        }
        return result;
    }

    @Benchmark
    public List<Integer> getOrderedRangesSmall(Data data) {
        return this.benchmarkGetOrderedRanges(data.smallRanges);
    }

    @Benchmark
    public List<Integer> getOrderedRangesLarge(Data data) {
        return this.benchmarkGetOrderedRanges(data.largeRanges);
    }

    private List<Integer> benchmarkGetOrderedRanges(List<SortedRangeSet> dataRanges) {
        ArrayList<Integer> result = new ArrayList<Integer>(dataRanges.size());
        for (int index = 0; index < dataRanges.size(); ++index) {
            int hash = 0;
            for (Range orderedRange : dataRanges.get(index).getRanges().getOrderedRanges()) {
                if (!orderedRange.isLowUnbounded()) {
                    hash = hash * 31 + orderedRange.getLowBoundedValue().hashCode();
                }
                if (orderedRange.isHighUnbounded()) continue;
                hash = hash * 31 + orderedRange.getHighBoundedValue().hashCode();
            }
            result.add(hash);
        }
        return result;
    }

    @Test
    public void test() {
        Data data = new Data();
        data.init();
        this.benchmarkBuilder(data);
        this.ofSingleRange(data);
        this.equalsSmall(data);
        this.equalsLarge(data);
        this.unionSmall(data);
        this.unionLarge(data);
        this.overlapsSmall(data);
        this.overlapsLarge(data);
        this.overlapsSmallOnVeryLarge(data);
        this.linearIntersectSmall(data);
        this.linearIntersectLarge(data);
        this.linearIntersectLarge(data);
        this.linearIntersectSmallOnVeryLarge(data);
        this.linearIntersectRangeOnLarge(data);
        this.linearIntersectDiscreteOnLarge(data);
        this.binaryIntersectSmall(data);
        this.binaryIntersectLarge(data);
        this.binaryIntersectLarge(data);
        this.binaryIntersectSmallOnVeryLarge(data);
        this.binaryIntersectRangeOnLarge(data);
        this.binaryIntersectDiscreteOnLarge(data);
        this.containsValueSmall(data);
        this.containsValueLarge(data);
        this.complementSmall(data);
        this.complementLarge(data);
        this.getOrderedRangesSmall(data);
        this.getOrderedRangesLarge(data);
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkSortedRangeSet.class).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public List<Range> ranges;
        public List<SortedRangeSet> smallRanges;
        public List<SortedRangeSet> largeRanges;
        private List<SortedRangeSet> veryLargeRanges;
        public SortedRangeSet largeDiscreteSortedRangeSet = SortedRangeSet.of((Type)BigintType.BIGINT, (Object)0L, (Object[])LongStream.range(1L, 100000L).boxed().toList().toArray());
        public SortedRangeSet largeRangeSortedRangeSet = SortedRangeSet.of((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)9L, (boolean)true), (Range[])((Range[])LongStream.rangeClosed(1L, 100000L).mapToObj(l -> Range.range((Type)BigintType.BIGINT, (Object)(l * 10L), (l % 2L == 1L ? 1 : 0) != 0, (Object)((l + 1L) * 10L - 1L), (l % 2L == 0L ? 1 : 0) != 0)).toList().toArray(Range[]::new)));

        @Setup(value=Level.Iteration)
        public void init() {
            this.ranges = new ArrayList<Range>();
            long factor = 0L;
            for (int i = 0; i < 10000; ++i) {
                long from = ThreadLocalRandom.current().nextLong(100L) + factor * 100L;
                long to = ThreadLocalRandom.current().nextLong(100L) + (factor + 1L) * 100L;
                ++factor;
                this.ranges.add(Range.range((Type)BigintType.BIGINT, (Object)from, (boolean)false, (Object)to, (boolean)false));
            }
            this.smallRanges = this.generateRangeSets(50000, 2);
            this.largeRanges = this.generateRangeSets(5000, 300);
            this.veryLargeRanges = this.generateRangeSets(5000, 30000);
        }

        private List<SortedRangeSet> generateRangeSets(int count, int size) {
            ArrayList<SortedRangeSet> sortedRangeSets = new ArrayList<SortedRangeSet>();
            for (int i = 0; i < count; ++i) {
                sortedRangeSets.add(this.generateRangeSet(size));
            }
            return sortedRangeSets;
        }

        private SortedRangeSet generateRangeSet(int size) {
            ArrayList<Range> selectedRanges = new ArrayList<Range>();
            for (int i = 0; i < size; ++i) {
                selectedRanges.add(this.ranges.get(ThreadLocalRandom.current().nextInt(this.ranges.size())));
            }
            return SortedRangeSet.copyOf((Type)BigintType.BIGINT, selectedRanges);
        }
    }
}

