/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.trino.spi.predicate.AllOrNoneValueSet;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.TestingTypeDeserializer;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAllOrNoneValueSet {
    @Test
    public void testAll() {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)valueSet.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)valueSet.isNone()).isFalse();
        Assertions.assertThat((boolean)valueSet.isAll()).isTrue();
        Assertions.assertThat((boolean)valueSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)valueSet.containsValue((Object)Slices.EMPTY_SLICE)).isTrue();
        Assertions.assertThatThrownBy(() -> ((AllOrNoneValueSet)valueSet).getSingleValue()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testNone() {
        AllOrNoneValueSet valueSet = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)valueSet.getType()).isEqualTo((Object)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)valueSet.isNone()).isTrue();
        Assertions.assertThat((boolean)valueSet.isAll()).isFalse();
        Assertions.assertThat((boolean)valueSet.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)valueSet.containsValue((Object)Slices.EMPTY_SLICE)).isFalse();
        Assertions.assertThatThrownBy(() -> ((AllOrNoneValueSet)valueSet).getSingleValue()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testIntersect() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)all.intersect((ValueSet)all)).isEqualTo((Object)all);
        Assertions.assertThat((Object)all.intersect((ValueSet)none)).isEqualTo((Object)none);
        Assertions.assertThat((Object)none.intersect((ValueSet)all)).isEqualTo((Object)none);
        Assertions.assertThat((Object)none.intersect((ValueSet)none)).isEqualTo((Object)none);
    }

    @Test
    public void testUnion() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)all.union((ValueSet)all)).isEqualTo((Object)all);
        Assertions.assertThat((Object)all.union((ValueSet)none)).isEqualTo((Object)all);
        Assertions.assertThat((Object)none.union((ValueSet)all)).isEqualTo((Object)all);
        Assertions.assertThat((Object)none.union((ValueSet)none)).isEqualTo((Object)none);
    }

    @Test
    public void testComplement() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)all.complement()).isEqualTo((Object)none);
        Assertions.assertThat((Object)none.complement()).isEqualTo((Object)all);
    }

    @Test
    public void testOverlaps() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)all.overlaps((ValueSet)all)).isTrue();
        Assertions.assertThat((boolean)all.overlaps((ValueSet)none)).isFalse();
        Assertions.assertThat((boolean)none.overlaps((ValueSet)all)).isFalse();
        Assertions.assertThat((boolean)none.overlaps((ValueSet)none)).isFalse();
    }

    @Test
    public void testSubtract() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)all.subtract((ValueSet)all)).isEqualTo((Object)none);
        Assertions.assertThat((Object)all.subtract((ValueSet)none)).isEqualTo((Object)all);
        Assertions.assertThat((Object)none.subtract((ValueSet)all)).isEqualTo((Object)none);
        Assertions.assertThat((Object)none.subtract((ValueSet)none)).isEqualTo((Object)none);
    }

    @Test
    public void testContains() {
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((boolean)all.contains((ValueSet)all)).isTrue();
        Assertions.assertThat((boolean)all.contains((ValueSet)none)).isTrue();
        Assertions.assertThat((boolean)none.contains((ValueSet)all)).isFalse();
        Assertions.assertThat((boolean)none.contains((ValueSet)none)).isTrue();
    }

    @Test
    public void testContainsValue() {
        Assertions.assertThat((boolean)AllOrNoneValueSet.all((Type)BigintType.BIGINT).containsValue((Object)42L)).isTrue();
        Assertions.assertThat((boolean)AllOrNoneValueSet.none((Type)BigintType.BIGINT).containsValue((Object)42L)).isFalse();
    }

    @Test
    public void testJsonSerialization() throws Exception {
        TestingTypeManager typeManager = new TestingTypeManager();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer(typeManager)));
        AllOrNoneValueSet all = AllOrNoneValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)all).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)all), AllOrNoneValueSet.class));
        AllOrNoneValueSet none = AllOrNoneValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG);
        Assertions.assertThat((Object)none).isEqualTo(mapper.readValue(mapper.writeValueAsString((Object)none), AllOrNoneValueSet.class));
    }

    @Test
    public void testExpandRanges() {
        Assertions.assertThat((Optional)ValueSet.all((Type)HyperLogLogType.HYPER_LOG_LOG).tryExpandRanges(10)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG).tryExpandRanges(10)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG).tryExpandRanges(1)).isEqualTo(Optional.of(List.of()));
        Assertions.assertThat((Optional)ValueSet.none((Type)HyperLogLogType.HYPER_LOG_LOG).tryExpandRanges(0)).isEqualTo(Optional.of(List.of()));
    }
}

