/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.predicate;

import io.airlift.slice.Slices;
import io.trino.spi.predicate.Range;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRange {
    @Test
    public void testInvertedBounds() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)0L, (boolean)true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("low must be less than or equal to high");
    }

    @Test
    public void testSingleValueExclusive() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)10L, (boolean)true)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)true, (Object)10L, (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.range((Type)BigintType.BIGINT, (Object)10L, (boolean)false, (Object)10L, (boolean)false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("invalid bounds for single value range");
    }

    @Test
    public void testSingleValue() {
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)1L, (boolean)true).isSingleValue()).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true).isSingleValue()).isFalse();
        Assertions.assertThat((boolean)Range.range((Type)DoubleType.DOUBLE, (Object)1.1, (boolean)true, (Object)1.1, (boolean)true).isSingleValue()).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"a"), (boolean)true, (Object)Slices.utf8Slice((String)"a"), (boolean)true).isSingleValue()).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)true, (boolean)true, (Object)true, (boolean)true).isSingleValue()).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BooleanType.BOOLEAN, (Object)false, (boolean)true, (Object)true, (boolean)true).isSingleValue()).isFalse();
    }

    @Test
    public void testAllRange() {
        Range range = Range.all((Type)BigintType.BIGINT);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isLowInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assertions.assertThat((boolean)range.isHighUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isHighInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isTrue();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testGreaterThanRange() {
        Range range = Range.greaterThan((Type)BigintType.BIGINT, (Object)1L);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isLowInclusive()).isFalse();
        Assertions.assertThat((Object)range.getLowBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isHighUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isHighInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testGreaterThanOrEqualRange() {
        Range range = Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isLowInclusive()).isTrue();
        Assertions.assertThat((Object)range.getLowBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isHighUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isHighInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getHighBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is high-unbounded");
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testLessThanRange() {
        Range range = Range.lessThan((Type)BigintType.BIGINT, (Object)1L);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isLowInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assertions.assertThat((boolean)range.isHighUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isHighInclusive()).isFalse();
        Assertions.assertThat((Object)range.getHighBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testLessThanOrEqualRange() {
        Range range = Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isTrue();
        Assertions.assertThat((boolean)range.isLowInclusive()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Range)range).getLowBoundedValue()).isInstanceOf(IllegalStateException.class)).hasMessage("The range is low-unbounded");
        Assertions.assertThat((boolean)range.isHighUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isHighInclusive()).isTrue();
        Assertions.assertThat((Object)range.getHighBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testEqualRange() {
        Range range = Range.equal((Type)BigintType.BIGINT, (Object)1L);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isLowInclusive()).isTrue();
        Assertions.assertThat((Object)range.getLowBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isHighUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isHighInclusive()).isTrue();
        Assertions.assertThat((Object)range.getHighBoundedValue()).isEqualTo((Object)1L);
        Assertions.assertThat((boolean)range.isSingleValue()).isTrue();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testRange() {
        Range range = Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)2L, (boolean)true);
        Assertions.assertThat((boolean)range.isLowUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isLowInclusive()).isFalse();
        Assertions.assertThat((Object)range.getLowBoundedValue()).isEqualTo((Object)0L);
        Assertions.assertThat((boolean)range.isHighUnbounded()).isFalse();
        Assertions.assertThat((boolean)range.isHighInclusive()).isTrue();
        Assertions.assertThat((Object)range.getHighBoundedValue()).isEqualTo((Object)2L);
        Assertions.assertThat((boolean)range.isSingleValue()).isFalse();
        Assertions.assertThat((boolean)range.isAll()).isFalse();
        Assertions.assertThat((Object)range.getType()).isEqualTo((Object)BigintType.BIGINT);
    }

    @Test
    public void testGetSingleValue() {
        Assertions.assertThat((Object)Range.equal((Type)BigintType.BIGINT, (Object)0L).getSingleValue()).isEqualTo((Object)0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Range.lessThan((Type)BigintType.BIGINT, (Object)0L).getSingleValue()).isInstanceOf(IllegalStateException.class)).hasMessage("Range does not have just a single value");
    }

    @Test
    public void testContains() {
        Assertions.assertThat((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.all((Type)BigintType.BIGINT))).isTrue();
        Assertions.assertThat((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Range.all((Type)BigintType.BIGINT).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.equal((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Range.equal((Type)BigintType.BIGINT, (Object)0L).contains(Range.all((Type)BigintType.BIGINT))).isFalse();
        Assertions.assertThat((boolean)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)0L))).isTrue();
        Assertions.assertThat((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.greaterThan((Type)BigintType.BIGINT, (Object)1L))).isTrue();
        Assertions.assertThat((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L).contains(Range.lessThan((Type)BigintType.BIGINT, (Object)0L))).isFalse();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true))).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)2L, (boolean)true).contains(Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false))).isFalse();
    }

    @Test
    public void testSpan() {
        Assertions.assertThat((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L))).isEqualTo((Object)Range.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Range.all((Type)BigintType.BIGINT));
        Assertions.assertThat((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.equal((Type)BigintType.BIGINT, (Object)2L))).isEqualTo((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false));
        Assertions.assertThat((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).span(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false))).isEqualTo((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)10L, (boolean)false));
        Assertions.assertThat((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.equal((Type)BigintType.BIGINT, (Object)0L))).isEqualTo((Object)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)0L));
        Assertions.assertThat((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).span(Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)10L))).isEqualTo((Object)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L));
        Assertions.assertThat((Object)Range.lessThan((Type)BigintType.BIGINT, (Object)1L).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L))).isEqualTo((Object)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L));
        Assertions.assertThat((Object)Range.all((Type)BigintType.BIGINT).span(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L))).isEqualTo((Object)Range.all((Type)BigintType.BIGINT));
    }

    @Test
    public void testOverlaps() {
        Assertions.assertThat((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).overlaps(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L))).isTrue();
        Assertions.assertThat((boolean)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L).overlaps(Range.lessThan((Type)BigintType.BIGINT, (Object)2L))).isFalse();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)2L))).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false))).isTrue();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false))).isFalse();
        Assertions.assertThat((boolean)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).overlaps(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false))).isTrue();
        Assertions.assertThat((boolean)Range.all((Type)BigintType.BIGINT).overlaps(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE))).isTrue();
    }

    @Test
    public void testIntersect() {
        Assertions.assertThat((Optional)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L).intersect(Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L))).contains((Object)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)true));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.equal((Type)BigintType.BIGINT, (Object)2L))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)2L));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false).intersect(Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)10L, (boolean)false))).contains((Object)Range.range((Type)BigintType.BIGINT, (Object)2L, (boolean)false, (Object)3L, (boolean)false));
        Assertions.assertThat((Optional)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true).intersect(Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L));
        Assertions.assertThat((Optional)Range.all((Type)BigintType.BIGINT).intersect(Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE))).contains((Object)Range.equal((Type)BigintType.BIGINT, (Object)Long.MAX_VALUE));
    }

    @Test
    public void testExceptionalIntersect() {
        Range greaterThan2 = Range.greaterThan((Type)BigintType.BIGINT, (Object)2L);
        Range lessThan2 = Range.lessThan((Type)BigintType.BIGINT, (Object)2L);
        Assertions.assertThat((Optional)greaterThan2.intersect(lessThan2)).isEmpty();
        Range range1To3Exclusive = Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)false);
        Range range3To10 = Range.range((Type)BigintType.BIGINT, (Object)3L, (boolean)true, (Object)10L, (boolean)false);
        Assertions.assertThat((Optional)range1To3Exclusive.intersect(range3To10)).isEmpty();
    }
}

