/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.testing;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.reflect.Reflection;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

public final class InterfaceTestUtils {
    private InterfaceTestUtils() {
    }

    public static <I, C extends I> void assertAllMethodsOverridden(Class<I> iface, Class<C> clazz) {
        InterfaceTestUtils.assertAllMethodsOverridden(iface, clazz, (Set<Method>)ImmutableSet.of());
    }

    public static <I, C extends I> void assertAllMethodsOverridden(Class<I> iface, Class<C> clazz, Set<Method> exclusions) {
        Preconditions.checkArgument((boolean)iface.isAssignableFrom(clazz), (String)"%s is not supertype of %s", iface, clazz);
        exclusions = new HashSet<Method>(exclusions);
        for (Method method : iface.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass() == Object.class) continue;
            try {
                Method override = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                if (method.getReturnType().isAssignableFrom(override.getReturnType())) continue;
                Fail.fail((String)String.format("%s is not assignable from %s for method %s", method.getReturnType(), override.getReturnType(), method));
            }
            catch (NoSuchMethodException e) {
                if (exclusions.remove(method)) continue;
                Fail.fail((String)String.format("%s does not override [%s]", clazz.getName(), method));
            }
        }
        if (!exclusions.isEmpty()) {
            Fail.fail((String)("Following exclusions are redundant: " + String.valueOf(exclusions)));
        }
    }

    public static <I, C extends I> void assertProperForwardingMethodsAreCalled(Class<I> iface, Function<I, C> forwardingInstanceFactory) {
        InterfaceTestUtils.assertProperForwardingMethodsAreCalled(iface, forwardingInstanceFactory, (Set<Method>)ImmutableSet.of());
    }

    public static <I, C extends I> void assertProperForwardingMethodsAreCalled(Class<I> iface, Function<I, C> forwardingInstanceFactory, Set<Method> exclusions) {
        for (Method actualMethod : Sets.difference((Set)ImmutableSet.copyOf((Object[])iface.getMethods()), exclusions)) {
            Object[] actualArguments = new Object[actualMethod.getParameterCount()];
            for (int i = 0; i < actualArguments.length; ++i) {
                if (!actualMethod.getParameterTypes()[i].isPrimitive()) continue;
                actualArguments[i] = Defaults.defaultValue(actualMethod.getParameterTypes()[i]);
            }
            C forwardingInstance = forwardingInstanceFactory.apply(Reflection.newProxy(iface, (proxy, expectedMethod, expectedArguments) -> {
                Assertions.assertThat((String)actualMethod.getName()).isEqualTo(expectedMethod.getName());
                if (actualMethod.getReturnType().isPrimitive()) {
                    return Defaults.defaultValue(actualMethod.getReturnType());
                }
                return null;
            }));
            try {
                actualMethod.invoke(forwardingInstance, actualArguments);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Invocation of %s has failed", actualMethod), e);
            }
        }
    }
}

