/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowType {
    private final TypeOperators typeOperators = new TypeOperators();

    @Test
    public void testRowDisplayName() {
        List<RowType.Field> fields = Arrays.asList(RowType.field((String)"bool_col", (Type)BooleanType.BOOLEAN), RowType.field((String)"double_col", (Type)DoubleType.DOUBLE), RowType.field((String)"array_col", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"map_col", (Type)new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, this.typeOperators)));
        RowType row = RowType.from(fields);
        Assertions.assertThat((String)row.getDisplayName()).isEqualTo("row(bool_col boolean, double_col double, array_col array(varchar), map_col map(boolean, double))");
    }

    @Test
    public void testRowDisplayNoColumnNames() {
        List<Type> types = Arrays.asList(BooleanType.BOOLEAN, DoubleType.DOUBLE, new ArrayType((Type)VarcharType.VARCHAR), new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, this.typeOperators));
        RowType row = RowType.anonymous(types);
        Assertions.assertThat((String)row.getDisplayName()).isEqualTo("row(boolean, double, array(varchar), map(boolean, double))");
    }

    @Test
    public void testRowDisplayMixedUnnamedColumns() {
        List<RowType.Field> fields = Arrays.asList(RowType.field((Type)BooleanType.BOOLEAN), RowType.field((String)"double_col", (Type)DoubleType.DOUBLE), RowType.field((Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"map_col", (Type)new MapType((Type)BooleanType.BOOLEAN, (Type)DoubleType.DOUBLE, this.typeOperators)));
        RowType row = RowType.from(fields);
        Assertions.assertThat((String)row.getDisplayName()).isEqualTo("row(boolean, double_col double, array(varchar), map_col map(boolean, double))");
    }
}

