/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.type.SqlTimestamp;
import java.time.LocalDateTime;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlTimestamp {
    @Test
    public void testBaseline() {
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)0, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)1, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.0");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)2, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.00");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)3, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)4, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.0000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)5, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.00000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)6, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)7, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.0000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)8, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.00000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)9, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.000000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)10, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.0000000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)11, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.00000000000");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)0L, (int)0).toString()).isEqualTo("1970-01-01 00:00:00.000000000000");
    }

    @Test
    public void testFromMillis() {
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)0, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)1, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.1");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)2, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.11");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)3, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.111");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)4, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.1110");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)5, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.11100");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)6, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.111000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)7, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.1110000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)8, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.11100000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)9, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.111000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)10, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.1110000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)11, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.11100000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)12, (long)111L).toString()).isEqualTo("1970-01-01 00:00:00.111000000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)0, (long)555L).toString()).isEqualTo("1970-01-01 00:00:01");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)1, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.6");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)2, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.56");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)3, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.555");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)4, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.5550");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)5, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.55500");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)6, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.555000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)7, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.5550000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)8, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.55500000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)9, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.555000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)10, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.5550000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)11, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.55500000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)12, (long)555L).toString()).isEqualTo("1970-01-01 00:00:00.555000000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)0, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)1, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.1");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)2, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.11");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)3, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.111");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)4, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.1110");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)5, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.11100");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)6, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.111000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)7, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.1110000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)8, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.11100000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)9, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.111000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)10, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.1110000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)11, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.11100000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)12, (long)-889L).toString()).isEqualTo("1969-12-31 23:59:59.111000000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)0, (long)-445L).toString()).isEqualTo("1970-01-01 00:00:00");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)1, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.6");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)2, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.56");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)3, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.555");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)4, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.5550");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)5, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.55500");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)6, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.555000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)7, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.5550000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)8, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.55500000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)9, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.555000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)10, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.5550000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)11, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.55500000000");
        Assertions.assertThat((String)SqlTimestamp.fromMillis((int)12, (long)-445L).toString()).isEqualTo("1969-12-31 23:59:59.555000000000");
    }

    @Test
    public void testRoundTo() {
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(0).toString()).isEqualTo("1970-01-01 00:00:00");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(1).toString()).isEqualTo("1970-01-01 00:00:00.1");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(2).toString()).isEqualTo("1970-01-01 00:00:00.11");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(3).toString()).isEqualTo("1970-01-01 00:00:00.111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(4).toString()).isEqualTo("1970-01-01 00:00:00.1111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(5).toString()).isEqualTo("1970-01-01 00:00:00.11111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(6).toString()).isEqualTo("1970-01-01 00:00:00.111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(7).toString()).isEqualTo("1970-01-01 00:00:00.1111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(8).toString()).isEqualTo("1970-01-01 00:00:00.11111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(9).toString()).isEqualTo("1970-01-01 00:00:00.111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(10).toString()).isEqualTo("1970-01-01 00:00:00.1111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(11).toString()).isEqualTo("1970-01-01 00:00:00.11111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)111111L, (int)111111).roundTo(12).toString()).isEqualTo("1970-01-01 00:00:00.111111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(0).toString()).isEqualTo("1970-01-01 00:00:01");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(1).toString()).isEqualTo("1970-01-01 00:00:00.6");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(2).toString()).isEqualTo("1970-01-01 00:00:00.56");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(3).toString()).isEqualTo("1970-01-01 00:00:00.556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(4).toString()).isEqualTo("1970-01-01 00:00:00.5556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(5).toString()).isEqualTo("1970-01-01 00:00:00.55556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(6).toString()).isEqualTo("1970-01-01 00:00:00.555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(7).toString()).isEqualTo("1970-01-01 00:00:00.5555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(8).toString()).isEqualTo("1970-01-01 00:00:00.55555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(9).toString()).isEqualTo("1970-01-01 00:00:00.555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(10).toString()).isEqualTo("1970-01-01 00:00:00.5555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(11).toString()).isEqualTo("1970-01-01 00:00:00.55555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555).roundTo(12).toString()).isEqualTo("1970-01-01 00:00:00.555555555555");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(0).toString()).isEqualTo("1969-12-31 23:59:59");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(1).toString()).isEqualTo("1969-12-31 23:59:59.1");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(2).toString()).isEqualTo("1969-12-31 23:59:59.11");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(3).toString()).isEqualTo("1969-12-31 23:59:59.111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(4).toString()).isEqualTo("1969-12-31 23:59:59.1111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(5).toString()).isEqualTo("1969-12-31 23:59:59.11111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(6).toString()).isEqualTo("1969-12-31 23:59:59.111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(7).toString()).isEqualTo("1969-12-31 23:59:59.1111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(8).toString()).isEqualTo("1969-12-31 23:59:59.11111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(9).toString()).isEqualTo("1969-12-31 23:59:59.111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(10).toString()).isEqualTo("1969-12-31 23:59:59.1111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(11).toString()).isEqualTo("1969-12-31 23:59:59.11111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-888889L, (int)111111).roundTo(12).toString()).isEqualTo("1969-12-31 23:59:59.111111111111");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(0).toString()).isEqualTo("1970-01-01 00:00:00");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(1).toString()).isEqualTo("1969-12-31 23:59:59.6");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(2).toString()).isEqualTo("1969-12-31 23:59:59.56");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(3).toString()).isEqualTo("1969-12-31 23:59:59.556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(4).toString()).isEqualTo("1969-12-31 23:59:59.5556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(5).toString()).isEqualTo("1969-12-31 23:59:59.55556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(6).toString()).isEqualTo("1969-12-31 23:59:59.555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(7).toString()).isEqualTo("1969-12-31 23:59:59.5555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(8).toString()).isEqualTo("1969-12-31 23:59:59.55555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(9).toString()).isEqualTo("1969-12-31 23:59:59.555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(10).toString()).isEqualTo("1969-12-31 23:59:59.5555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(11).toString()).isEqualTo("1969-12-31 23:59:59.55555555556");
        Assertions.assertThat((String)SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555).roundTo(12).toString()).isEqualTo("1969-12-31 23:59:59.555555555555");
    }

    @Test
    public void testToLocalDateTime() {
        SqlTimestamp timestamp = SqlTimestamp.newInstance((int)9, (long)1367846055987654L, (int)321000);
        Assertions.assertThat((String)timestamp.toString()).isEqualTo("2013-05-06 13:14:15.987654321");
        Assertions.assertThat((LocalDateTime)timestamp.toLocalDateTime()).isEqualTo((Object)LocalDateTime.of(2013, 5, 6, 13, 14, 15, 987654321));
        timestamp = SqlTimestamp.newInstance((int)9, (long)-178454744012346L, (int)321000);
        Assertions.assertThat((String)timestamp.toString()).isEqualTo("1964-05-06 13:14:15.987654321");
        Assertions.assertThat((LocalDateTime)timestamp.toLocalDateTime()).isEqualTo((Object)LocalDateTime.of(1964, 5, 6, 13, 14, 15, 987654321));
        timestamp = SqlTimestamp.newInstance((int)12, (long)555555L, (int)555555);
        Assertions.assertThat((String)timestamp.toString()).isEqualTo("1970-01-01 00:00:00.555555555555");
        Assertions.assertThat((LocalDateTime)timestamp.toLocalDateTime()).isEqualTo((Object)LocalDateTime.of(1970, 1, 1, 0, 0, 0, 555555556));
        timestamp = SqlTimestamp.newInstance((int)12, (long)-444445L, (int)555555);
        Assertions.assertThat((String)timestamp.toString()).isEqualTo("1969-12-31 23:59:59.555555555555");
        Assertions.assertThat((LocalDateTime)timestamp.toLocalDateTime()).isEqualTo((Object)LocalDateTime.of(1969, 12, 31, 23, 59, 59, 555555556));
    }
}

