/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimeZoneNotSupportedException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimeZoneKey {
    private static final TimeZoneKey PLUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)420L);
    private static final TimeZoneKey MINUS_7_KEY = TimeZoneKey.getTimeZoneKeyForOffset((long)-420L);

    @Test
    public void testUTC() {
        Assertions.assertThat((short)TimeZoneKey.UTC_KEY.getKey()).isEqualTo((short)0);
        Assertions.assertThat((String)TimeZoneKey.UTC_KEY.getId()).isEqualTo("UTC");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((short)0)).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Z")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Zulu")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UCT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Universal")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"+00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"-00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"+0000")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"-0000")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-00:00")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UCT")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/Universal")).isSameAs((Object)TimeZoneKey.UTC_KEY);
    }

    @Test
    public void testHourOffsetZone() {
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("GMT7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"GMT-7")).isSameAs((Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UT0");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UT7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UT-7")).isSameAs((Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("UTC0");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("UTC7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"UTC-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/GMT7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT+7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/GMT-7")).isSameAs((Object)PLUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UT0");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UT7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UT-7")).isSameAs((Object)MINUS_7_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC0");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-0")).isSameAs((Object)TimeZoneKey.UTC_KEY);
        this.assertTimeZoneNotSupported("Etc/UTC7");
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7:00")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-07:00")).isSameAs((Object)MINUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7:00")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+07:00")).isSameAs((Object)PLUS_7_KEY);
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-7:35")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC-07:35")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+7:35")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"Etc/UTC+07:35")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"+0735")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)455L));
        Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)"-0735")).isSameAs((Object)TimeZoneKey.getTimeZoneKeyForOffset((long)-455L));
    }

    @Test
    public void testZoneKeyLookup() {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((short)timeZoneKey.getKey())).isSameAs((Object)timeZoneKey);
            Assertions.assertThat((Object)TimeZoneKey.getTimeZoneKey((String)timeZoneKey.getId())).isSameAs((Object)timeZoneKey);
        }
    }

    @Test
    public void testMaxTimeZoneKey() {
        boolean foundMax = false;
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            ((AbstractBooleanAssert)Assertions.assertThat((timeZoneKey.getKey() <= TimeZoneKey.MAX_TIME_ZONE_KEY ? 1 : 0) != 0).describedAs(String.valueOf(timeZoneKey) + " key is larger than max key " + TimeZoneKey.MAX_TIME_ZONE_KEY, new Object[0])).isTrue();
            foundMax = foundMax || timeZoneKey.getKey() == TimeZoneKey.MAX_TIME_ZONE_KEY;
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)foundMax).describedAs("Did not find a time zone with the MAX_TIME_ZONE_KEY", new Object[0])).isTrue();
    }

    @Test
    public void testZoneKeyIdRange() {
        boolean[] hasValue = new boolean[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            short key = timeZoneKey.getKey();
            ((AbstractBooleanAssert)Assertions.assertThat((key >= 0 ? 1 : 0) != 0).describedAs(String.valueOf(timeZoneKey) + " has a negative time zone key", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasValue[key]).describedAs("Another time zone has the same zone key as " + String.valueOf(timeZoneKey), new Object[0])).isFalse();
            hasValue[key] = true;
        }
        Assertions.assertThat((boolean)hasValue[2040]).isFalse();
        hasValue[2040] = true;
        Assertions.assertThat((boolean)hasValue[2180]).isFalse();
        hasValue[2180] = true;
        Assertions.assertThat((boolean)hasValue[2186]).isFalse();
        hasValue[2186] = true;
        Assertions.assertThat((boolean)hasValue[2196]).isFalse();
        hasValue[2196] = true;
        Assertions.assertThat((boolean)hasValue[2174]).isFalse();
        hasValue[2174] = true;
        for (int i = 0; i < hasValue.length; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasValue[i]).describedAs("There is no time zone with key " + i, new Object[0])).isTrue();
        }
    }

    @Test
    public void testZoneKeyData() {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        ImmutableSortedSet timeZoneKeysSortedByKey = ImmutableSortedSet.copyOf(Comparator.comparingInt(TimeZoneKey::getKey), (Collection)TimeZoneKey.getTimeZoneKeys());
        for (TimeZoneKey timeZoneKey : timeZoneKeysSortedByKey) {
            hasher.putShort(timeZoneKey.getKey());
            hasher.putString((CharSequence)timeZoneKey.getId(), StandardCharsets.UTF_8);
        }
        ((AbstractLongAssert)Assertions.assertThat((long)hasher.hash().asLong()).describedAs("zone-index.properties file contents changed!", new Object[0])).isEqualTo(4825838578917475630L);
    }

    @Test
    public void testRoundTripSerialization() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        for (TimeZoneKey zoneKey : TimeZoneKey.getTimeZoneKeys()) {
            String json = mapper.writeValueAsString((Object)zoneKey);
            Object value = mapper.readValue(json, zoneKey.getClass());
            Assertions.assertThat((Object)value).isEqualTo((Object)zoneKey);
        }
    }

    private void assertTimeZoneNotSupported(String zoneId) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TimeZoneKey.getTimeZoneKey((String)zoneId)).isInstanceOf(TimeZoneNotSupportedException.class)).hasMessageStartingWith("Time zone not supported: ");
    }
}

