/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestVarchars {
    @Test
    public void testTruncateToLength() {
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abc"), (int)0)).isEqualTo((Object)Slices.utf8Slice((String)""));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abc"), (int)1)).isEqualTo((Object)Slices.utf8Slice((String)"a"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abc"), (int)4)).isEqualTo((Object)Slices.utf8Slice((String)"abc"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abcde"), (int)5)).isEqualTo((Object)Slices.utf8Slice((String)"abcde"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\u0430\u0431\u0432"), (int)0)).isEqualTo((Object)Slices.utf8Slice((String)""));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\u0430\u0431\u0432"), (int)1)).isEqualTo((Object)Slices.utf8Slice((String)"\u0430"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\u0430\u0431\u0432"), (int)4)).isEqualTo((Object)Slices.utf8Slice((String)"\u0430\u0431\u0432"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\u0430\u0431\u0432\u0433\u0434"), (int)5)).isEqualTo((Object)Slices.utf8Slice((String)"\u0430\u0431\u0432\u0433\u0434"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79\ud843\udc53\ud843\udc78"), (int)0)).isEqualTo((Object)Slices.utf8Slice((String)""));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79\ud843\udc53\ud843\udc78"), (int)1)).isEqualTo((Object)Slices.utf8Slice((String)"\ud841\udf0e"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79"), (int)4)).isEqualTo((Object)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79\ud843\udc53\ud843\udc78"), (int)5)).isEqualTo((Object)Slices.utf8Slice((String)"\ud841\udf0e\ud841\udf31\ud841\udf79\ud843\udc53\ud843\udc78"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abc"), (VarcharType)VarcharType.createVarcharType((int)1))).isEqualTo((Object)Slices.utf8Slice((String)"a"));
        Assertions.assertThat((Comparable)Varchars.truncateToLength((Slice)Slices.utf8Slice((String)"abc"), (Type)VarcharType.createVarcharType((int)1))).isEqualTo((Object)Slices.utf8Slice((String)"a"));
    }

    @Test
    public void testByteCount() {
        TestVarchars.assertByteCount("abc", 0, 0, 1, "");
        TestVarchars.assertByteCount("abc", 0, 1, 0, "");
        TestVarchars.assertByteCount("abc", 1, 1, 1, "b");
        TestVarchars.assertByteCount("abc", 1, 1, 2, "b");
        TestVarchars.assertByteCount("abc", 1, 2, 1, "b");
        TestVarchars.assertByteCount("abc", 1, 2, 2, "bc");
        TestVarchars.assertByteCount("abc", 1, 2, 3, "bc");
        TestVarchars.assertByteCount("abc", 0, 3, 1, "a");
        TestVarchars.assertByteCount("abc", 0, 3, 5, "abc");
        TestVarchars.assertByteCountFailure("abc", 4, 5, 1);
        TestVarchars.assertByteCountFailure("abc", 5, 0, 1);
        TestVarchars.assertByteCountFailure("abc", -1, 1, 1);
        TestVarchars.assertByteCountFailure("abc", 1, -1, 1);
        TestVarchars.assertByteCountFailure("abc", 1, 1, -1);
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 0, 1, "");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 1, 0, "");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 2, 1, "\u0430");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 4, 1, "\u0430");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 1, 1, Slices.utf8Slice((String)"\u0430").getBytes(0, 1));
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 2, 2, 2, "\u0431");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 2, 2, 0, "");
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 0, 3, 5, Slices.utf8Slice((String)"\u0430\u0431").getBytes(0, 3));
        TestVarchars.assertByteCountFailure("\u0430\u0431\u0432", 8, 5, 1);
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 1, 1, 5, Slices.utf8Slice((String)"\u0430").getBytes(1, 1));
        TestVarchars.assertByteCount("\u0430\u0431\u0432", 2, 1, 5, Slices.utf8Slice((String)"\u0431").getBytes(0, 1));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 0, 2, "");
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 1, 1, Slices.utf8Slice((String)"\u6000").getBytes(0, 1));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 2, 1, Slices.utf8Slice((String)"\u6000").getBytes(0, 2));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 3, 1, "\u6000");
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 6, 1, "\u6000");
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 6, 2, 4, Slices.utf8Slice((String)"\u6002").getBytes(0, 2));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 0, 12, 6, "\u6000\u6001\u6002\u6003");
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 1, 6, 2, Slices.utf8Slice((String)"\u6000\u6001\u6002").getBytes(1, 6));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 2, 6, 2, Slices.utf8Slice((String)"\u6000\u6001\u6002").getBytes(2, 6));
        TestVarchars.assertByteCount("\u6000\u6001\u6002\u6003", 3, 6, 2, Slices.utf8Slice((String)"\u6000\u6001\u6002").getBytes(3, 6));
        TestVarchars.assertByteCountFailure("\u6000\u6001\u6002\u6003", 21, 0, 1);
        TestVarchars.assertByteCount(new byte[]{-127, -127, -127}, 0, 2, 0, new byte[0]);
        TestVarchars.assertByteCount(new byte[]{-127, -127, -127}, 0, 2, 1, new byte[]{-127, -127});
        TestVarchars.assertByteCount(new byte[]{-127, -127, -127}, 0, 2, 3, new byte[]{-127, -127});
    }

    private static void assertByteCountFailure(String string, int offset, int length, int codePointCount) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Varchars.byteCount((Slice)Slices.utf8Slice((String)string), (int)offset, (int)length, (int)codePointCount)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("invalid offset/length|length must be greater than or equal to zero|codePointsCount must be greater than or equal to zero");
    }

    private static void assertByteCount(String actual, int offset, int length, int codePointCount, String expected) {
        TestVarchars.assertByteCount(Slices.utf8Slice((String)actual).getBytes(), offset, length, codePointCount, Slices.utf8Slice((String)expected).getBytes());
    }

    private static void assertByteCount(String actual, int offset, int length, int codePointCount, byte[] expected) {
        TestVarchars.assertByteCount(Slices.utf8Slice((String)actual).getBytes(), offset, length, codePointCount, expected);
    }

    private static void assertByteCount(byte[] actual, int offset, int length, int codePointCount, byte[] expected) {
        Slice slice = Slices.wrappedBuffer((byte[])actual);
        int truncatedLength = Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)codePointCount);
        byte[] bytes = slice.getBytes(offset, truncatedLength);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)expected);
    }
}

