/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.trino.spi.connector.ConstantProperty;
import io.trino.spi.connector.GroupingProperty;
import io.trino.spi.connector.SortingProperty;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ConstantProperty.class, name="constant"), @JsonSubTypes.Type(value=SortingProperty.class, name="sorting"), @JsonSubTypes.Type(value=GroupingProperty.class, name="grouping")})
public sealed interface LocalProperty<E>
permits GroupingProperty, SortingProperty, ConstantProperty {
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> var1);

    public boolean isOrderSensitive();

    public boolean isSimplifiedBy(LocalProperty<E> var1);

    default public Optional<LocalProperty<E>> withConstants(Set<E> constants) {
        LinkedHashSet<E> set = new LinkedHashSet<E>(this.getColumns());
        set.removeAll(constants);
        if (set.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.constrain(set));
    }

    default public LocalProperty<E> constrain(Set<E> columns) {
        if (!columns.equals(this.getColumns())) {
            throw new IllegalArgumentException(String.format("Cannot constrain %s with %s", this, columns));
        }
        return this;
    }

    public Set<E> getColumns();
}

