/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public class ArrayType
extends AbstractType {
    private static final VarHandle INT_HANDLE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final InvocationConvention READ_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.FLAT);
    private static final InvocationConvention READ_FLAT_TO_BLOCK_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT);
    private static final InvocationConvention WRITE_FLAT_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention IDENTICAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG);
    private static final InvocationConvention COMPARISON_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final MethodHandle READ_FLAT;
    private static final MethodHandle READ_FLAT_TO_BLOCK;
    private static final MethodHandle WRITE_FLAT;
    private static final MethodHandle EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle IDENTICAL;
    private static final MethodHandle INDETERMINATE;
    private static final MethodHandle COMPARISON;
    private static final String ARRAY_NULL_ELEMENT_MSG = "ARRAY comparison not supported for arrays with null elements";
    private final Type elementType;
    private volatile TypeOperatorDeclaration operatorDeclaration;

    public ArrayType(Type elementType) {
        super(new TypeSignature("array", TypeSignatureParameter.typeParameter(elementType.getTypeSignature())), Block.class, ArrayBlock.class);
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.operatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.operatorDeclaration;
    }

    private synchronized void generateTypeOperators(TypeOperators typeOperators) {
        if (this.operatorDeclaration != null) {
            return;
        }
        this.operatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addReadValueOperators(ArrayType.getReadValueOperatorMethodHandles(typeOperators, this.elementType)).addEqualOperators(ArrayType.getEqualOperatorMethodHandles(typeOperators, this.elementType)).addHashCodeOperators(ArrayType.getHashCodeOperatorMethodHandles(typeOperators, this.elementType)).addXxHash64Operators(ArrayType.getXxHash64OperatorMethodHandles(typeOperators, this.elementType)).addIdenticalOperators(ArrayType.getIdenticalOperatorInvokers(typeOperators, this.elementType)).addIndeterminateOperators(ArrayType.getIndeterminateOperatorInvokers(typeOperators, this.elementType)).addComparisonUnorderedLastOperators(ArrayType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedLastOperator, this.elementType)).addComparisonUnorderedFirstOperators(ArrayType.getComparisonOperatorInvokers(typeOperators::getComparisonUnorderedFirstOperator, this.elementType)).build();
    }

    private static List<OperatorMethodHandle> getReadValueOperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        MethodHandle elementReadOperator = typeOperators.getReadValueOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, InvocationConvention.InvocationArgumentConvention.FLAT));
        MethodHandle readFlat = MethodHandles.insertArguments(READ_FLAT, 0, elementType, elementReadOperator, elementType.getFlatFixedSize());
        MethodHandle readFlatToBlock = MethodHandles.insertArguments(READ_FLAT_TO_BLOCK, 0, elementReadOperator, elementType.getFlatFixedSize());
        MethodHandle elementWriteOperator = typeOperators.getReadValueOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FLAT_RETURN, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        MethodHandle writeFlatToBlock = MethodHandles.insertArguments(WRITE_FLAT, 0, elementType, elementWriteOperator, elementType.getFlatFixedSize(), elementType.isFlatVariableWidth());
        return List.of(new OperatorMethodHandle(READ_FLAT_CONVENTION, readFlat), new OperatorMethodHandle(READ_FLAT_TO_BLOCK_CONVENTION, readFlatToBlock), new OperatorMethodHandle(WRITE_FLAT_CONVENTION, writeFlatToBlock));
    }

    private static List<OperatorMethodHandle> getEqualOperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle equalOperator = typeOperators.getEqualOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(equalOperator)));
    }

    private static List<OperatorMethodHandle> getHashCodeOperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementHashCodeOperator = typeOperators.getHashCodeOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(elementHashCodeOperator)));
    }

    private static List<OperatorMethodHandle> getXxHash64OperatorMethodHandles(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementHashCodeOperator = typeOperators.getXxHash64Operator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(elementHashCodeOperator)));
    }

    private static List<OperatorMethodHandle> getIdenticalOperatorInvokers(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementIdenticalOperator = typeOperators.getIdenticalOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(IDENTICAL_CONVENTION, IDENTICAL.bindTo(elementIdenticalOperator)));
    }

    private static List<OperatorMethodHandle> getIndeterminateOperatorInvokers(TypeOperators typeOperators, Type elementType) {
        if (!elementType.isComparable()) {
            return Collections.emptyList();
        }
        MethodHandle elementIndeterminateOperator = typeOperators.getIndeterminateOperator(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(elementIndeterminateOperator)));
    }

    private static List<OperatorMethodHandle> getComparisonOperatorInvokers(BiFunction<Type, InvocationConvention, MethodHandle> comparisonOperatorFactory, Type elementType) {
        if (!elementType.isOrderable()) {
            return Collections.emptyList();
        }
        MethodHandle elementComparisonOperator = comparisonOperatorFactory.apply(elementType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.VALUE_BLOCK_POSITION_NOT_NULL));
        return Collections.singletonList(new OperatorMethodHandle(COMPARISON_CONVENTION, COMPARISON.bindTo(elementComparisonOperator)));
    }

    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isComparable() {
        return this.elementType.isComparable();
    }

    @Override
    public boolean isOrderable() {
        return this.elementType.isOrderable();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (block instanceof ArrayBlock) {
            return ((ArrayBlock)block).apply((valuesBlock, start, length) -> this.arrayBlockToObjectValues(session, valuesBlock, start, length), position);
        }
        Block arrayBlock = this.getObject(block, position);
        return this.arrayBlockToObjectValues(session, arrayBlock, 0, arrayBlock.getPositionCount());
    }

    private List<Object> arrayBlockToObjectValues(ConnectorSession session, Block block, int start, int length) {
        ArrayList<Object> values = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            values.add(this.elementType.getObjectValue(session, block, i + start));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeObject(blockBuilder, this.getObject(block, position));
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return ArrayType.read((ArrayBlock)block.getUnderlyingValueBlock(), block.getUnderlyingValuePosition(position));
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        Block arrayBlock = (Block)value;
        ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                this.elementType.appendTo(arrayBlock, i, elementBuilder);
            }
        });
    }

    @Override
    public int getFlatFixedSize() {
        return 8;
    }

    @Override
    public boolean isFlatVariableWidth() {
        return true;
    }

    @Override
    public int getFlatVariableWidthSize(Block block, int position) {
        Block array = this.getObject(block, position);
        int arrayLength = array.getPositionCount();
        int flatFixedSize = this.elementType.getFlatFixedSize();
        boolean variableWidth = this.elementType.isFlatVariableWidth();
        long size = (long)arrayLength * ((long)flatFixedSize + 1L);
        if (variableWidth) {
            for (int index = 0; index < arrayLength; ++index) {
                if (array.isNull(index)) continue;
                size += (long)this.elementType.getFlatVariableWidthSize(array, index);
            }
        }
        return Math.toIntExact(size);
    }

    @Override
    public int relocateFlatVariableWidthOffsets(byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) {
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4, variableSizeOffset);
        int positionCount = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int elementFixedSize = this.elementType.getFlatFixedSize();
        if (!this.elementType.isFlatVariableWidth()) {
            return positionCount * (1 + elementFixedSize);
        }
        return this.relocateVariableWidthData(positionCount, elementFixedSize, variableSizeSlice, variableSizeOffset);
    }

    private int relocateVariableWidthData(int positionCount, int elementFixedSize, byte[] slice, int offset) {
        int writeFixedOffset = offset;
        int writeVariableWidthOffset = offset + positionCount * (1 + elementFixedSize);
        for (int index = 0; index < positionCount; ++index) {
            if (slice[writeFixedOffset] != 0) {
                ++writeFixedOffset;
            } else {
                int elementVariableSize = this.elementType.relocateFlatVariableWidthOffsets(slice, ++writeFixedOffset, slice, writeVariableWidthOffset);
                writeVariableWidthOffset += elementVariableSize;
            }
            writeFixedOffset += elementFixedSize;
        }
        return writeVariableWidthOffset - offset;
    }

    @Override
    public ArrayBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder(this.elementType, blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    @Override
    public ArrayBlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 100);
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.singletonList(this.getElementType());
    }

    @Override
    public String getDisplayName() {
        return "array(" + this.elementType.getDisplayName() + ")";
    }

    private static Block read(ArrayBlock block, int position) {
        return block.getArray(position);
    }

    private static Block readFlat(Type elementType, MethodHandle elementReadFlat, int elementFixedSize, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice) throws Throwable {
        int positionCount = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int variableSizeOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4);
        BlockBuilder elementBuilder = elementType.createBlockBuilder(null, positionCount);
        ArrayType.readFlatElements(elementReadFlat, elementFixedSize, variableSizeSlice, variableSizeOffset, positionCount, elementBuilder);
        return elementBuilder.build();
    }

    private static void readFlatToBlock(MethodHandle elementReadFlat, int elementFixedSize, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, BlockBuilder blockBuilder) throws Throwable {
        int positionCount = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset);
        int variableSizeOffset = INT_HANDLE.get(fixedSizeSlice, fixedSizeOffset + 4);
        ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> ArrayType.readFlatElements(elementReadFlat, elementFixedSize, variableSizeSlice, variableSizeOffset, positionCount, elementBuilder));
    }

    private static void readFlatElements(MethodHandle elementReadFlat, int elementFixedSize, byte[] slice, int sliceOffset, int positionCount, BlockBuilder elementBuilder) throws Throwable {
        for (int i = 0; i < positionCount; ++i) {
            boolean elementIsNull;
            boolean bl = elementIsNull = slice[sliceOffset] != 0;
            if (elementIsNull) {
                elementBuilder.appendNull();
            } else {
                elementReadFlat.invokeExact(slice, sliceOffset + 1, slice, elementBuilder);
            }
            sliceOffset += 1 + elementFixedSize;
        }
    }

    private static void writeFlat(Type elementType, MethodHandle elementWriteFlat, int elementFixedSize, boolean elementVariableWidth, Block array, byte[] fixedSizeSlice, int fixedSizeOffset, byte[] variableSizeSlice, int variableSizeOffset) throws Throwable {
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset, array.getPositionCount());
        INT_HANDLE.set(fixedSizeSlice, fixedSizeOffset + 4, variableSizeOffset);
        ArrayType.writeFlatElements(elementType, elementWriteFlat, elementFixedSize, elementVariableWidth, array, variableSizeSlice, variableSizeOffset);
    }

    private static void writeFlatElements(Type elementType, MethodHandle elementWriteFlat, int elementFixedSize, boolean elementVariableWidth, Block array, byte[] slice, int offset) throws Throwable {
        array = array.getLoadedBlock();
        int positionCount = array.getPositionCount();
        int writeVariableWidthOffset = offset + positionCount * (1 + elementFixedSize);
        Block block = array;
        Objects.requireNonNull(block);
        Block block2 = block;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValueBlock.class, RunLengthEncodedBlock.class, DictionaryBlock.class, LazyBlock.class}, (Object)block2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ValueBlock valuesBlock = (ValueBlock)block2;
                for (int index = 0; index < positionCount; ++index) {
                    writeVariableWidthOffset = ArrayType.writeFlatElement(elementType, elementWriteFlat, elementVariableWidth, valuesBlock, index, slice, offset, writeVariableWidthOffset);
                    offset += 1 + elementFixedSize;
                }
                break;
            }
            case 1: {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block2;
                ValueBlock valuesBlock = rleBlock.getValue();
                for (int index = 0; index < positionCount; ++index) {
                    writeVariableWidthOffset = ArrayType.writeFlatElement(elementType, elementWriteFlat, elementVariableWidth, valuesBlock, 0, slice, offset, writeVariableWidthOffset);
                    offset += 1 + elementFixedSize;
                }
                break;
            }
            case 2: {
                DictionaryBlock dictionaryBlock = (DictionaryBlock)block2;
                ValueBlock valuesBlock = dictionaryBlock.getDictionary();
                for (int position = 0; position < positionCount; ++position) {
                    int index = dictionaryBlock.getId(position);
                    writeVariableWidthOffset = ArrayType.writeFlatElement(elementType, elementWriteFlat, elementVariableWidth, valuesBlock, index, slice, offset, writeVariableWidthOffset);
                    offset += 1 + elementFixedSize;
                }
                break;
            }
            case 3: {
                LazyBlock ignored = (LazyBlock)block2;
                throw new IllegalStateException("Did not expect LazyBlock after loading " + array.getClass().getSimpleName());
            }
        }
    }

    private static int writeFlatElement(Type elementType, MethodHandle elementWriteFlat, boolean elementVariableWidth, ValueBlock array, int index, byte[] slice, int offset, int writeVariableWidthOffset) throws Throwable {
        if (array.isNull(index)) {
            slice[offset] = 1;
        } else {
            int elementVariableSize = 0;
            if (elementVariableWidth) {
                elementVariableSize = elementType.getFlatVariableWidthSize(array, index);
            }
            elementWriteFlat.invokeExact(array, index, slice, offset + 1, slice, writeVariableWidthOffset);
            writeVariableWidthOffset += elementVariableSize;
        }
        return writeVariableWidthOffset;
    }

    private static Boolean equalOperator(MethodHandle equalOperator, Block leftArray, Block rightArray) throws Throwable {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        leftArray = leftArray.getLoadedBlock();
        rightArray = rightArray.getLoadedBlock();
        ValueBlock leftValues = leftArray.getUnderlyingValueBlock();
        ValueBlock rightValues = rightArray.getUnderlyingValueBlock();
        boolean unknown = false;
        for (int position = 0; position < leftArray.getPositionCount(); ++position) {
            int leftIndex = leftArray.getUnderlyingValuePosition(position);
            int rightIndex = rightArray.getUnderlyingValuePosition(position);
            if (leftValues.isNull(leftIndex) || rightValues.isNull(rightIndex)) {
                unknown = true;
                continue;
            }
            Boolean result = equalOperator.invokeExact(leftValues, leftIndex, rightValues, rightIndex);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static long hashOperator(MethodHandle hashOperator, Block array) throws Throwable {
        if ((array = array.getLoadedBlock()) instanceof ValueBlock) {
            ValueBlock valuesBlock = (ValueBlock)array;
            long hash = 0L;
            for (int index = 0; index < valuesBlock.getPositionCount(); ++index) {
                long elementHash = valuesBlock.isNull(index) ? 0L : hashOperator.invokeExact(valuesBlock, index);
                hash = 31L * hash + elementHash;
            }
            return hash;
        }
        if (array instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)array;
            ValueBlock valuesBlock = rleBlock.getValue();
            long elementHash = valuesBlock.isNull(0) ? 0L : hashOperator.invokeExact(valuesBlock, 0);
            long hash = 0L;
            for (int position = 0; position < valuesBlock.getPositionCount(); ++position) {
                hash = 31L * hash + elementHash;
            }
            return hash;
        }
        if (array instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)array;
            ValueBlock valuesBlock = dictionaryBlock.getDictionary();
            long hash = 0L;
            for (int position = 0; position < dictionaryBlock.getPositionCount(); ++position) {
                int index = dictionaryBlock.getId(position);
                long elementHash = valuesBlock.isNull(index) ? 0L : hashOperator.invokeExact(valuesBlock, index);
                hash = 31L * hash + elementHash;
            }
            return hash;
        }
        throw new IllegalArgumentException("Unsupported block type: " + array.getClass().getName());
    }

    private static boolean identicalOperator(MethodHandle identicalOperator, Block leftArray, Block rightArray) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftArray == null;
        boolean bl = rightIsNull = rightArray == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull == rightIsNull;
        }
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        leftArray = leftArray.getLoadedBlock();
        rightArray = rightArray.getLoadedBlock();
        ValueBlock leftValues = leftArray.getUnderlyingValueBlock();
        ValueBlock rightValues = rightArray.getUnderlyingValueBlock();
        for (int position = 0; position < leftArray.getPositionCount(); ++position) {
            boolean result;
            boolean rightValueIsNull;
            int leftIndex = leftArray.getUnderlyingValuePosition(position);
            int rightIndex = rightArray.getUnderlyingValuePosition(position);
            boolean leftValueIsNull = leftValues.isNull(leftIndex);
            if (leftValueIsNull != (rightValueIsNull = rightValues.isNull(rightIndex))) {
                return false;
            }
            if (leftValueIsNull || (result = identicalOperator.invokeExact(leftValues, leftIndex, rightValues, rightIndex))) continue;
            return false;
        }
        return true;
    }

    private static boolean indeterminateOperator(MethodHandle elementIndeterminateFunction, Block array, boolean isNull) throws Throwable {
        if (isNull) {
            return true;
        }
        if ((array = array.getLoadedBlock()) instanceof ValueBlock) {
            ValueBlock valuesBlock = (ValueBlock)array;
            for (int index = 0; index < valuesBlock.getPositionCount(); ++index) {
                if (valuesBlock.isNull(index)) {
                    return true;
                }
                if (!elementIndeterminateFunction.invoke(valuesBlock, index)) continue;
                return true;
            }
            return false;
        }
        if (array instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)array;
            ValueBlock valuesBlock = rleBlock.getValue();
            if (valuesBlock.isNull(0)) {
                return true;
            }
            return elementIndeterminateFunction.invoke(valuesBlock, 0);
        }
        if (array instanceof DictionaryBlock) {
            DictionaryBlock dictionaryBlock = (DictionaryBlock)array;
            ValueBlock valuesBlock = dictionaryBlock.getDictionary();
            for (int position = 0; position < valuesBlock.getPositionCount(); ++position) {
                int index = dictionaryBlock.getId(position);
                if (valuesBlock.isNull(index)) {
                    return true;
                }
                if (!elementIndeterminateFunction.invoke(valuesBlock, index)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unsupported block type: " + array.getClass().getName());
    }

    private static long comparisonOperator(MethodHandle comparisonOperator, Block leftArray, Block rightArray) throws Throwable {
        leftArray = leftArray.getLoadedBlock();
        rightArray = rightArray.getLoadedBlock();
        ValueBlock leftValues = leftArray.getUnderlyingValueBlock();
        ValueBlock rightValues = rightArray.getUnderlyingValueBlock();
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (int position = 0; position < len; ++position) {
            TypeUtils.checkElementNotNull(leftArray.isNull(position), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(position), ARRAY_NULL_ELEMENT_MSG);
            int leftIndex = leftArray.getUnderlyingValuePosition(position);
            int rightIndex = rightArray.getUnderlyingValuePosition(position);
            long result = comparisonOperator.invokeExact(leftValues, leftIndex, rightValues, rightIndex);
            if (result == 0L) continue;
            return result;
        }
        return Integer.compare(leftArray.getPositionCount(), rightArray.getPositionCount());
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            READ_FLAT = lookup.findStatic(ArrayType.class, "readFlat", MethodType.methodType(Block.class, Type.class, MethodHandle.class, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class));
            READ_FLAT_TO_BLOCK = lookup.findStatic(ArrayType.class, "readFlatToBlock", MethodType.methodType(Void.TYPE, MethodHandle.class, Integer.TYPE, byte[].class, Integer.TYPE, byte[].class, BlockBuilder.class));
            WRITE_FLAT = lookup.findStatic(ArrayType.class, "writeFlat", MethodType.methodType(Void.TYPE, Type.class, MethodHandle.class, Integer.TYPE, Boolean.TYPE, Block.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE));
            EQUAL = lookup.findStatic(ArrayType.class, "equalOperator", MethodType.methodType(Boolean.class, MethodHandle.class, Block.class, Block.class));
            HASH_CODE = lookup.findStatic(ArrayType.class, "hashOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class));
            IDENTICAL = lookup.findStatic(ArrayType.class, "identicalOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Block.class));
            INDETERMINATE = lookup.findStatic(ArrayType.class, "indeterminateOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Boolean.TYPE));
            COMPARISON = lookup.findStatic(ArrayType.class, "comparisonOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class, Block.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

