/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.function.table;

import io.trino.spi.Experimental;
import io.trino.spi.function.table.Preconditions;
import jakarta.annotation.Nullable;

@Experimental(eta="2022-10-31")
public abstract class ArgumentSpecification {
    private final String name;
    private final boolean required;
    private final Object defaultValue;

    ArgumentSpecification(String name, boolean required, @Nullable Object defaultValue) {
        this.name = Preconditions.checkNotNullOrEmpty(name, "name");
        Preconditions.checkArgument(!required || defaultValue == null, "non-null default value for a required argument");
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

