/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.airlift.slice.Slice;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.List;

public abstract class AbstractType
implements Type {
    private final TypeSignature signature;
    private final Class<?> javaType;
    private final Class<? extends ValueBlock> valueBlockType;

    protected AbstractType(TypeSignature signature, Class<?> javaType, Class<? extends ValueBlock> valueBlockType) {
        this.signature = signature;
        this.javaType = javaType;
        this.valueBlockType = valueBlockType;
    }

    @Override
    public final TypeSignature getTypeSignature() {
        return this.signature;
    }

    @Override
    public String getDisplayName() {
        return this.signature.toString();
    }

    @Override
    public final Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public Class<? extends ValueBlock> getValueBlockType() {
        return this.valueBlockType;
    }

    @Override
    public List<Type> getTypeParameters() {
        return List.of();
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object getObject(Block block, int position) {
        return this.getSlice(block, position);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        this.writeSlice(blockBuilder, (Slice)value);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getTypeSignature().equals(((Type)o).getTypeSignature());
    }

    public int hashCode() {
        return this.signature.hashCode();
    }
}

