/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.Iterables;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public abstract class AbstractTestBlockBuilder<T> {
    protected abstract BlockBuilder createBlockBuilder();

    protected abstract List<T> getTestValues();

    protected abstract T getUnusedTestValue();

    protected abstract ValueBlock blockFromValues(Iterable<T> var1);

    protected abstract List<T> blockToValues(ValueBlock var1);

    @Test
    public void verifyTestData() {
        List<T> values = this.getTestValues();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(values).hasSize(5)).doesNotHaveDuplicates()).doesNotContainNull()).doesNotContain(new Object[]{this.getUnusedTestValue()});
        ValueBlock valueBlock = this.blockFromValues(values);
        Assertions.assertThat(this.blockToValues(valueBlock)).isEqualTo(values);
    }

    @Test
    public void testAppend() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlock(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.append(inputValues, 1);
        blockBuilder.append(inputValues, 3);
        blockBuilder.append(inputValues, 1);
        blockBuilder.append(inputValues, 3);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isFalse();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactly(new Object[]{values.get(1), values.get(3), values.get(1), values.get(3)});
    }

    @Test
    public void testAppendWithNulls() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlockWithOddPositionsNull(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.append(inputValues, 1);
        blockBuilder.append(inputValues, 3);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isTrue();
        List<T> actualValues = this.blockToValues(valueBlock);
        ((ListAssert)Assertions.assertThat(actualValues).hasSize(2)).containsOnlyNulls();
        blockBuilder.append(inputValues, 2);
        valueBlock = blockBuilder.buildValueBlock();
        actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactly(new Object[]{null, null, values.get(2)});
    }

    @Test
    public void testAppendRepeated() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlock(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendRepeated(inputValues, 1, 10);
        blockBuilder.appendRepeated(inputValues, 3, 10);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isFalse();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactlyElementsOf(Iterables.concat(Collections.nCopies(10, values.get(1)), Collections.nCopies(10, values.get(3))));
    }

    @Test
    public void testAppendRepeatedWithNulls() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlockWithOddPositionsNull(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendRepeated(inputValues, 1, 10);
        blockBuilder.appendRepeated(inputValues, 3, 10);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isTrue();
        List<T> actualValues = this.blockToValues(valueBlock);
        ((ListAssert)Assertions.assertThat(actualValues).hasSize(20)).containsOnlyNulls();
        Assertions.assertThat((Object)blockBuilder.build()).isInstanceOf(RunLengthEncodedBlock.class);
        blockBuilder.appendRepeated(inputValues, 2, 10);
        valueBlock = blockBuilder.buildValueBlock();
        actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactlyElementsOf(Iterables.concat(Collections.nCopies(20, null), Collections.nCopies(10, values.get(2))));
    }

    @Test
    public void testAppendRange() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlock(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendRange(inputValues, 1, 3);
        blockBuilder.appendRange(inputValues, 2, 3);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isFalse();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactlyElementsOf(Iterables.concat(values.subList(1, 4), values.subList(2, 5)));
    }

    @Test
    public void testAppendRangeWithNulls() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlockWithOddPositionsNull(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendRange(inputValues, 1, 3);
        blockBuilder.appendRange(inputValues, 2, 3);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isTrue();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactly(new Object[]{null, values.get(2), null, values.get(2), null, values.get(4)});
    }

    @Test
    public void testAppendPositions() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlock(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendPositions(inputValues, new int[]{-100, 1, 3, 2, -100}, 1, 3);
        blockBuilder.appendPositions(inputValues, new int[]{-100, 4, 0, -100}, 1, 2);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isFalse();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactly(new Object[]{values.get(1), values.get(3), values.get(2), values.get(4), values.get(0)});
    }

    @Test
    public void testAppendPositionsWithNull() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlockWithOddPositionsNull(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendPositions(inputValues, new int[]{-100, 1, 3, 2, -100}, 1, 3);
        blockBuilder.appendPositions(inputValues, new int[]{-100, 4, 0, -100}, 1, 2);
        ValueBlock valueBlock = blockBuilder.buildValueBlock();
        Assertions.assertThat((boolean)valueBlock.mayHaveNull()).isTrue();
        List<T> actualValues = this.blockToValues(valueBlock);
        Assertions.assertThat(actualValues).containsExactly(new Object[]{null, null, values.get(2), values.get(4), values.get(0)});
    }

    @Test
    public void testResetTo() {
        List<T> values = this.getTestValues();
        ValueBlock inputValues = this.createOffsetBlock(values);
        BlockBuilder blockBuilder = this.createBlockBuilder();
        blockBuilder.appendRange(inputValues, 0, inputValues.getPositionCount());
        Assertions.assertThat(this.blockToValues(blockBuilder.buildValueBlock())).containsExactlyElementsOf(values);
        blockBuilder.resetTo(4);
        Assertions.assertThat(this.blockToValues(blockBuilder.buildValueBlock())).containsExactlyElementsOf(values.subList(0, 4));
        blockBuilder.appendRange(inputValues, 0, inputValues.getPositionCount());
        Assertions.assertThat(this.blockToValues(blockBuilder.buildValueBlock())).containsExactlyElementsOf(Iterables.concat(values.subList(0, 4), values));
        blockBuilder.resetTo(0);
        Assertions.assertThat(this.blockToValues(blockBuilder.buildValueBlock())).isEmpty();
        blockBuilder.appendRange(inputValues, 0, inputValues.getPositionCount());
        Assertions.assertThat(this.blockToValues(blockBuilder.buildValueBlock())).containsExactlyElementsOf(values);
    }

    private ValueBlock createOffsetBlock(List<T> values) {
        return this.blockFromValues(Iterables.concat(Collections.nCopies(2, this.getUnusedTestValue()), values, Collections.nCopies(2, this.getUnusedTestValue()))).getRegion(2, values.size());
    }

    private ValueBlock createOffsetBlockWithOddPositionsNull(List<T> values) {
        ArrayList<T> blockValues = new ArrayList<T>();
        blockValues.add(this.getUnusedTestValue());
        blockValues.add(this.getUnusedTestValue());
        for (int i = 0; i < values.size(); ++i) {
            T value = values.get(i);
            if (i % 2 == 0) {
                blockValues.add(value);
                continue;
            }
            blockValues.add(null);
        }
        blockValues.add(this.getUnusedTestValue());
        blockValues.add(this.getUnusedTestValue());
        return this.blockFromValues(blockValues).getRegion(2, values.size());
    }
}

