/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.BlockUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlockUtil {
    @Test
    public void testCalculateNewArraySize() {
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)200)).isEqualTo(300);
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)200, (int)10)).isEqualTo(300);
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)200, (int)500)).isEqualTo(500);
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)0x7FFFFFF4)).isEqualTo(0x7FFFFFF5);
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)10, (int)0x7FFFFFF5)).isEqualTo(0x7FFFFFF5);
        Assertions.assertThat((int)BlockUtil.calculateNewArraySize((int)1, (int)0)).isEqualTo(64);
        Assertions.assertThatThrownBy(() -> BlockUtil.calculateNewArraySize((int)Integer.MAX_VALUE)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> BlockUtil.calculateNewArraySize((int)0, (int)Integer.MAX_VALUE)).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BlockUtil.calculateNewArraySize((int)0x7FFFFFF5)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot grow array beyond size %d".formatted(0x7FFFFFF5));
    }
}

