/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.ByteArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.List;

public class TestByteArrayBlockBuilder
extends AbstractTestBlockBuilder<Byte> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new ByteArrayBlockBuilder(null, 1);
    }

    @Override
    protected List<Byte> getTestValues() {
        return List.of(Byte.valueOf((byte)10), Byte.valueOf((byte)11), Byte.valueOf((byte)12), Byte.valueOf((byte)13), Byte.valueOf((byte)14));
    }

    @Override
    protected Byte getUnusedTestValue() {
        return (byte)-1;
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Byte> values) {
        ByteArrayBlockBuilder blockBuilder = new ByteArrayBlockBuilder(null, 1);
        for (Byte value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeByte(value.byteValue());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Byte> blockToValues(ValueBlock valueBlock) {
        ByteArrayBlock byteArrayBlock = (ByteArrayBlock)valueBlock;
        ArrayList<Byte> actualValues = new ArrayList<Byte>(byteArrayBlock.getPositionCount());
        for (int i = 0; i < byteArrayBlock.getPositionCount(); ++i) {
            if (byteArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(byteArrayBlock.getByte(i));
        }
        return actualValues;
    }
}

