/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.block.Fixed12BlockBuilder;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.List;

public class TestFixed12BlockBuilder
extends AbstractTestBlockBuilder<Fixed12> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new Fixed12BlockBuilder(null, 1);
    }

    @Override
    protected List<Fixed12> getTestValues() {
        return List.of(new Fixed12(90L, 10), new Fixed12(91L, 11), new Fixed12(92L, 12), new Fixed12(93L, 13), new Fixed12(94L, 14));
    }

    @Override
    protected Fixed12 getUnusedTestValue() {
        return new Fixed12(-1L, -2);
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Fixed12> values) {
        Fixed12BlockBuilder blockBuilder = new Fixed12BlockBuilder(null, 1);
        for (Fixed12 value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeFixed12(value.first(), value.second());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Fixed12> blockToValues(ValueBlock valueBlock) {
        Fixed12Block fixed12ArrayBlock = (Fixed12Block)valueBlock;
        ArrayList<Fixed12> actualValues = new ArrayList<Fixed12>(fixed12ArrayBlock.getPositionCount());
        for (int i = 0; i < fixed12ArrayBlock.getPositionCount(); ++i) {
            if (fixed12ArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(new Fixed12(fixed12ArrayBlock.getFixed12First(i), fixed12ArrayBlock.getFixed12Second(i)));
        }
        return actualValues;
    }

    public record Fixed12(long first, int second) {
    }
}

