/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.IntArrayBlock;
import io.trino.spi.block.IntArrayBlockBuilder;
import io.trino.spi.block.ValueBlock;
import java.util.ArrayList;
import java.util.List;

public class TestIntArrayBlockBuilder
extends AbstractTestBlockBuilder<Integer> {
    @Override
    protected BlockBuilder createBlockBuilder() {
        return new IntArrayBlockBuilder(null, 1);
    }

    @Override
    protected List<Integer> getTestValues() {
        return List.of(Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14));
    }

    @Override
    protected Integer getUnusedTestValue() {
        return -1;
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<Integer> values) {
        IntArrayBlockBuilder blockBuilder = new IntArrayBlockBuilder(null, 1);
        for (Integer value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeInt(value.intValue());
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<Integer> blockToValues(ValueBlock valueBlock) {
        IntArrayBlock intArrayBlock = (IntArrayBlock)valueBlock;
        ArrayList<Integer> actualValues = new ArrayList<Integer>(intArrayBlock.getPositionCount());
        for (int i = 0; i < intArrayBlock.getPositionCount(); ++i) {
            if (intArrayBlock.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            actualValues.add(intArrayBlock.getInt(i));
        }
        return actualValues;
    }
}

