/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.AbstractTestBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.SqlRow;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRowBlockBuilder
extends AbstractTestBlockBuilder<TestRow> {
    @Test
    public void testBuilderProducesNullRleForNullRows() {
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().build(), 0);
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().appendNull().build(), 1);
        TestRowBlockBuilder.assertIsAllNulls(TestRowBlockBuilder.blockBuilder().appendNull().appendNull().build(), 2);
    }

    private static BlockBuilder blockBuilder() {
        return new RowBlockBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), null, 10);
    }

    private static void assertIsAllNulls(Block block, int expectedPositionCount) {
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedPositionCount);
        if (expectedPositionCount <= 1) {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(RowBlock.class);
        } else {
            Assertions.assertThat((Class)block.getClass()).isEqualTo(RunLengthEncodedBlock.class);
            Assertions.assertThat((Class)((RunLengthEncodedBlock)block).getValue().getClass()).isEqualTo(RowBlock.class);
        }
        if (expectedPositionCount > 0) {
            Assertions.assertThat((boolean)block.isNull(0)).isTrue();
        }
    }

    @Override
    protected BlockBuilder createBlockBuilder() {
        return new RowBlockBuilder(List.of(VarcharType.VARCHAR, IntegerType.INTEGER, BooleanType.BOOLEAN), null, 1);
    }

    @Override
    protected List<TestRow> getTestValues() {
        return List.of(new TestRow("apple", 2, true), new TestRow("bear", 5, false), new TestRow(null, 7, true), new TestRow("dinosaur", 9, false), new TestRow("", 22, true));
    }

    @Override
    protected TestRow getUnusedTestValue() {
        return new TestRow("unused", -1, false);
    }

    @Override
    protected ValueBlock blockFromValues(Iterable<TestRow> values) {
        RowBlockBuilder blockBuilder = new RowBlockBuilder(List.of(VarcharType.VARCHAR, IntegerType.INTEGER, BooleanType.BOOLEAN), null, 1);
        for (TestRow row : values) {
            if (row == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(fieldBuilders -> {
                if (row.name() == null) {
                    ((BlockBuilder)fieldBuilders.get(0)).appendNull();
                } else {
                    VarcharType.VARCHAR.writeString((BlockBuilder)fieldBuilders.get(0), row.name());
                }
                IntegerType.INTEGER.writeLong((BlockBuilder)fieldBuilders.get(1), (long)row.number());
                BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(2), row.flag());
            });
        }
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected List<TestRow> blockToValues(ValueBlock valueBlock) {
        RowBlock block = (RowBlock)valueBlock;
        ArrayList<TestRow> actualValues = new ArrayList<TestRow>(block.getPositionCount());
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                actualValues.add(null);
                continue;
            }
            SqlRow sqlRow = block.getRow(i);
            actualValues.add(new TestRow((String)VarcharType.VARCHAR.getObjectValue(null, (Block)sqlRow.getUnderlyingFieldBlock(0), sqlRow.getUnderlyingFieldPosition(0)), IntegerType.INTEGER.getInt((Block)sqlRow.getUnderlyingFieldBlock(1), sqlRow.getUnderlyingFieldPosition(1)), BooleanType.BOOLEAN.getBoolean((Block)sqlRow.getUnderlyingFieldBlock(2), sqlRow.getUnderlyingFieldPosition(2))));
        }
        return actualValues;
    }

    public record TestRow(String name, int number, boolean flag) {
    }
}

